/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.mixin;

import fuzs.blockrunner.data.BlockSpeedManager;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private static final UUID SPEED_MODIFIER_CUSTOM_BLOCK_SPEED_UUID = UUID.fromString("23237052-61AD-11EB-AE93-0242AC130002");

    public LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    protected void checkFallDamage$head(double y, boolean onGroundIn, BlockState state, BlockPos pos, CallbackInfo callbackInfo) {
        if (!this.f_19853_.f_46443_ && onGroundIn && this.f_19789_ > 0.0f) {
            this.removeCustomBlockSpeed();
            this.tryAddCustomBlockSpeed();
        }
    }

    @Unique
    protected void removeCustomBlockSpeed() {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (attributeinstance != null && attributeinstance.m_22111_(SPEED_MODIFIER_CUSTOM_BLOCK_SPEED_UUID) != null) {
            attributeinstance.m_22120_(SPEED_MODIFIER_CUSTOM_BLOCK_SPEED_UUID);
        }
    }

    @Unique
    protected void tryAddCustomBlockSpeed() {
        if (!this.m_20075_().m_60795_() && this.onCustomSpeedBlock()) {
            double customSpeed = BlockSpeedManager.INSTANCE.getSpeedFactor(this.f_19853_.m_8055_(this.custom$getBlockPosBelowThatAffectsMyMovement2()).m_60734_());
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null || customSpeed == 1.0) {
                return;
            }
            double baseValue = attributeinstance.m_22115_();
            customSpeed = customSpeed * baseValue - baseValue;
            attributeinstance.m_22118_(new AttributeModifier(SPEED_MODIFIER_CUSTOM_BLOCK_SPEED_UUID, "Custom block speed boost", customSpeed, AttributeModifier.Operation.ADDITION));
        }
    }

    @Shadow
    public abstract AttributeInstance m_21051_(Attribute var1);

    @Unique
    protected boolean onCustomSpeedBlock() {
        return BlockSpeedManager.INSTANCE.hasCustomSpeed(this.f_19853_.m_8055_(this.custom$getBlockPosBelowThatAffectsMyMovement2()).m_60734_());
    }

    @Unique
    protected BlockPos custom$getBlockPosBelowThatAffectsMyMovement2() {
        return new BlockPos(this.m_20185_(), this.m_142469_().f_82289_ - 0.4375001, this.m_20189_());
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getBlockSpeedFactor$head(CallbackInfoReturnable<Float> callbackInfo) {
        if (this.onCustomSpeedBlock()) {
            callbackInfo.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")})
    protected void onChangedBlock$tail(BlockPos pos, CallbackInfo callbackInfo) {
        if (this.m_6757_(this.m_20075_())) {
            this.removeCustomBlockSpeed();
        }
        this.tryAddCustomBlockSpeed();
    }

    @Shadow
    protected abstract boolean m_6757_(BlockState var1);
}

