/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fuzs.blockrunner.BlockRunner;
import fuzs.blockrunner.data.SpeedHolderValue;
import fuzs.blockrunner.network.message.S2CBlockSpeedMessage;
import fuzs.puzzleslib.core.ModLoaderEnvironment;
import fuzs.puzzleslib.json.JsonConfigFileUtil;
import fuzs.puzzleslib.network.message.Message;
import fuzs.puzzleslib.proxy.IProxy;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockSpeedManager
implements PreparableReloadListener {
    public static final BlockSpeedManager INSTANCE = new BlockSpeedManager();
    private static final String CONFIG_FILE_NAME = "blockrunner.json";
    private static final Set<SpeedHolderValue> DEFAULT_BLOCK_SPEEDS = new SpeedHolderValue.Builder().add(Blocks.f_152481_, 1.35).add((TagKey<Block>)BlockTags.f_13091_, 1.15).build();
    private final Set<SpeedHolderValue> customBlockSpeedValues = Sets.newHashSet();
    private Map<Block, Double> customBlockSpeeds;

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        if (ModLoaderEnvironment.isServer()) {
            BlockRunner.NETWORK.sendTo((Message)new S2CBlockSpeedMessage(this.serialize(this.customBlockSpeedValues)), (ServerPlayer)evt.getPlayer());
        }
    }

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier p_10780_, ResourceManager p_10781_, ProfilerFiller p_10782_, ProfilerFiller p_10783_, Executor p_10784_, Executor p_10785_) {
        return p_10780_.m_6769_((Object)Unit.INSTANCE).thenRunAsync(this::load, p_10785_);
    }

    private void load() {
        JsonConfigFileUtil.getAndLoad((String)CONFIG_FILE_NAME, this::serialize, this::deserialize);
        if (ModLoaderEnvironment.isServer() && IProxy.INSTANCE.getGameServer() != null) {
            BlockRunner.NETWORK.sendToAll((Message)new S2CBlockSpeedMessage(this.serialize(this.customBlockSpeedValues)));
        }
    }

    private void dissolve() {
        if (this.customBlockSpeeds == null) {
            HashMap customBlockSpeeds = Maps.newHashMap();
            try {
                for (SpeedHolderValue value : this.customBlockSpeedValues) {
                    value.addValues(customBlockSpeeds);
                }
            }
            catch (Exception e) {
                BlockRunner.LOGGER.error(e.getMessage());
                customBlockSpeeds.clear();
            }
            this.customBlockSpeeds = customBlockSpeeds;
        }
    }

    public boolean hasCustomSpeed(Block block) {
        this.dissolve();
        return this.customBlockSpeeds.containsKey(block);
    }

    public double getSpeedFactor(Block block) {
        this.dissolve();
        return this.customBlockSpeeds.getOrDefault(block, 1.0);
    }

    private void serialize(File jsonFile) {
        JsonConfigFileUtil.saveToFile((File)jsonFile, (JsonElement)this.serialize(DEFAULT_BLOCK_SPEEDS));
    }

    private JsonObject serialize(Set<SpeedHolderValue> values) {
        JsonObject jsonElements = new JsonObject();
        for (SpeedHolderValue value : values) {
            value.serialize(jsonElements);
        }
        return jsonElements;
    }

    private void deserialize(FileReader reader) {
        this.deserialize((JsonObject)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonObject.class));
    }

    public void deserialize(JsonObject jsonElements) {
        this.customBlockSpeedValues.clear();
        this.customBlockSpeeds = null;
        HashSet customBlockSpeedValues = Sets.newHashSet();
        for (Map.Entry entry : jsonElements.entrySet()) {
            String key = (String)entry.getKey();
            double speedValue = ((JsonElement)entry.getValue()).getAsDouble();
            if (key.startsWith("#")) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(key.substring(1)));
                customBlockSpeedValues.add(new SpeedHolderValue.TagValue((TagKey<Block>)tag, speedValue));
                continue;
            }
            ResourceLocation resourcelocation = new ResourceLocation(key);
            if (ForgeRegistries.BLOCKS.containsKey(resourcelocation)) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourcelocation);
                customBlockSpeedValues.add(new SpeedHolderValue.BlockValue(block, speedValue));
                continue;
            }
            throw new JsonSyntaxException("Unknown block type '" + resourcelocation + "', valid types are: " + Joiner.on((String)", ").join((Iterable)ForgeRegistries.BLOCKS.getKeys()));
        }
        this.customBlockSpeedValues.addAll(customBlockSpeedValues);
    }
}

