/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner;

import fuzs.blockrunner.data.BlockSpeedManager;
import fuzs.blockrunner.network.message.S2CBlockSpeedMessage;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.network.NetworkHandler;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="blockrunner")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockRunner {
    public static final String MOD_ID = "blockrunner";
    public static final String MOD_NAME = "Block Runner";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Block Runner");
    public static final NetworkHandler NETWORK = NetworkHandler.of((String)"blockrunner", (boolean)true, (boolean)true);

    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        PuzzlesLib.setSideOnly();
        BlockRunner.registerHandlers();
        BlockRunner.registerMessages();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> evt.addListener((PreparableReloadListener)BlockSpeedManager.INSTANCE));
        MinecraftForge.EVENT_BUS.addListener(BlockSpeedManager.INSTANCE::onPlayerLoggedIn);
    }

    private static void registerMessages() {
        NETWORK.register(S2CBlockSpeedMessage.class, S2CBlockSpeedMessage::new, MessageDirection.TO_CLIENT);
    }
}

