/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.util;

import com.unrealdinnerbone.jamd.JAMDRegistry;
import com.unrealdinnerbone.jamd.block.PortalBlock;
import com.unrealdinnerbone.jamd.block.PortalTileEntity;
import com.unrealdinnerbone.jamd.util.SimpleTeleporter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.ITeleporter;

public class TelerportUtils {
    public static void teleport(Block clickedBlock, Player playerEntity, Level toWorld, BlockPos blockPos) throws RuntimeException {
        if (!toWorld.m_5776_() && playerEntity.f_19853_ instanceof ServerLevel && toWorld instanceof ServerLevel) {
            BlockPos portalLocation = TelerportUtils.findPortalLocation(toWorld, blockPos).orElseThrow(() -> new RuntimeException("Cant find location to spawn portal"));
            if (toWorld.m_8055_(portalLocation).m_60795_()) {
                toWorld.m_46597_(portalLocation, ((PortalBlock)JAMDRegistry.MINE_PORTAL_BLOCK.get()).m_49966_());
            }
            playerEntity.changeDimension((ServerLevel)toWorld, (ITeleporter)new SimpleTeleporter(portalLocation.m_123341_(), portalLocation.m_7494_().m_123342_(), portalLocation.m_123343_()));
        }
    }

    private static Optional<BlockPos> findPortalLocation(Level worldTo, BlockPos fromPos) {
        if (worldTo.m_8055_(fromPos).m_60734_() == JAMDRegistry.MINE_PORTAL_BLOCK.get() && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.m_7494_());
        }
        int range = 5;
        return Optional.ofNullable(ChunkPos.m_45596_((ChunkPos)worldTo.m_46745_(fromPos).m_7697_(), (int)range).map(chunkPos -> worldTo.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_5928_()).flatMap(Collection::stream).collect(Collectors.toList()).stream().filter(pos -> worldTo.m_7702_(pos) instanceof PortalTileEntity).findFirst().orElseGet(() -> {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (int y = worldTo.m_141937_(); y < worldTo.m_151558_(); ++y) {
                for (int x = fromPos.m_123341_() - 6; x < fromPos.m_123341_() + 6; ++x) {
                    for (int z = fromPos.m_123343_() - 6; z < fromPos.m_123343_() + 6; ++z) {
                        mutableBlockPos.m_122178_(x, y, z);
                        BlockState blockState = worldTo.m_8055_((BlockPos)mutableBlockPos);
                        if (!blockState.m_60795_() || !TelerportUtils.isSafeSpawnLocation(worldTo, mutableBlockPos.m_7494_())) continue;
                        return mutableBlockPos;
                    }
                }
            }
            return null;
        }));
    }

    private static boolean isSafeSpawnLocation(Level world, BlockPos blockPos) {
        return world.m_8055_(blockPos).m_60795_() && world.m_8055_(blockPos.m_7494_()).m_60795_();
    }
}

