/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.core.Vector3;
import com.lothrazar.library.dim.DimensionTransit;
import com.lothrazar.library.packet.PacketPlayerFalldamage;
import com.lothrazar.library.registry.PacketRegistry;
import com.lothrazar.library.util.LevelWorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;

public class EntityUtil {
    private static final double ENTITY_PULL_DIST = 0.4;
    private static final double ENTITY_PULL_SPEED_CUTOFF = 3.0;
    private static final float ITEMSPEEDFAR = 0.9f;
    private static final float ITEMSPEEDCLOSE = 0.2f;
    private static final int TICKS_FALLDIST_SYNC = 22;

    public static boolean haveSameDimension(Entity tamed, Entity owner) {
        return LevelWorldUtil.dimensionToString(tamed.f_19853_).equalsIgnoreCase(LevelWorldUtil.dimensionToString(owner.f_19853_));
    }

    public static boolean isTamedByPlayer(Entity entity, Player player) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity tamed = (OwnableEntity)entity;
            return tamed.m_142504_() != null && tamed.m_142504_().equals(player.m_142081_());
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return horse.m_30615_() != null && horse.m_30615_().equals(player.m_142081_());
        }
        return false;
    }

    private static boolean enderTeleportEvent(LivingEntity player, Level world, double x, double y, double z) {
        if (player.m_20201_() != player) {
            return false;
        }
        EntityUtil.teleportWallSafe(player, world, x, y, z);
        return true;
    }

    public static boolean enderTeleportEvent(LivingEntity player, Level world, BlockPos target) {
        return EntityUtil.enderTeleportEvent(player, world, (float)target.m_123341_() + 0.5f, (float)target.m_123342_() + 0.5f, (float)target.m_123343_() + 0.5f);
    }

    private static void teleportWallSafe(LivingEntity player, Level world, double x, double y, double z) {
        BlockPos coords = new BlockPos(x, y, z);
        world.m_46865_(coords).m_8092_(true);
        player.m_6021_(x, y, z);
        EntityUtil.moveEntityWallSafe((Entity)player, world);
    }

    public static void moveEntityWallSafe(Entity entity, Level world) {
        while (!world.m_45786_(entity)) {
            entity.m_6021_(entity.f_19854_, entity.f_19855_ + 1.0, entity.f_19856_);
        }
    }

    public static Direction getFacing(LivingEntity entity) {
        int yaw = (int)entity.m_146908_();
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 22;
        int facing = (yaw %= 360) / 45;
        return Direction.m_122407_((int)(facing / 2));
    }

    public static double getSpeedTranslated(double speed) {
        return speed * 100.0;
    }

    public static void launchDirection(Entity entity, float power, Direction facing) {
        double velX = 0.0;
        double velZ = 0.0;
        double velY = 0.0;
        switch (facing) {
            case EAST: {
                velX = Math.abs(power);
                velZ = 0.0;
                break;
            }
            case WEST: {
                velX = -1.0f * Math.abs(power);
                velZ = 0.0;
                break;
            }
            case NORTH: {
                velX = 0.0;
                velZ = -1.0f * Math.abs(power);
                break;
            }
            case SOUTH: {
                velX = 0.0;
                velZ = Math.abs(power);
                break;
            }
        }
        Entity ridingEntity = entity.m_20202_();
        if (ridingEntity != null) {
            entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
            ridingEntity.f_19789_ = 0.0f;
            ridingEntity.m_5997_(velX, velY, velZ);
        } else {
            entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
            entity.f_19789_ = 0.0f;
            entity.m_5997_(velX, velY, velZ);
        }
    }

    public static void launch(Entity entity, float rotationPitch, float power) {
        float rotationYaw = entity.m_146908_();
        EntityUtil.launch(entity, rotationPitch, rotationYaw, power);
    }

    public static void launch(Entity entity, float rotationPitch, float rotationYaw, float power) {
        Entity ridingEntity;
        float mountPower = (float)((double)power + 0.5);
        double velX = -Mth.m_14031_((float)(rotationYaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velZ = Mth.m_14089_((float)(rotationYaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velY = -Mth.m_14031_((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        if (velY < 0.0) {
            velY *= -1.0;
        }
        if ((ridingEntity = entity.m_20202_()) != null) {
            entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
            ridingEntity.f_19789_ = 0.0f;
            ridingEntity.m_5997_(velX * (double)mountPower, velY * (double)mountPower, velZ * (double)mountPower);
        } else {
            entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
            entity.f_19789_ = 0.0f;
            entity.m_5997_(velX, velY, velZ);
        }
    }

    public static AABB makeBoundingBox(BlockPos center, int hRadius, int vRadius) {
        return EntityUtil.makeBoundingBox(center.m_123341_(), center.m_123342_(), center.m_123343_(), hRadius, vRadius);
    }

    public static AABB makeBoundingBox(double x, double y, double z, int hRadius, int vRadius) {
        return new AABB(x - (double)hRadius, y - (double)vRadius, z - (double)hRadius, x + (double)hRadius, y + (double)vRadius, z + (double)hRadius);
    }

    public static int moveEntityItemsInRegion(Level world, BlockPos pos, int hRadius, int vRadius) {
        return EntityUtil.moveEntityItemsInRegion(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), hRadius, vRadius, true);
    }

    public static int moveEntityItemsInRegion(Level world, double x, double y, double z, int hRadius, int vRadius, boolean towardsPos) {
        AABB range = EntityUtil.makeBoundingBox(x, y, z, hRadius, vRadius);
        List<Entity> all = EntityUtil.getItemExp(world, range);
        return EntityUtil.pullEntityList(x, y, z, towardsPos, all);
    }

    public static List<Entity> getItemExp(Level world, AABB range) {
        ArrayList<Entity> all = new ArrayList<Entity>();
        all.addAll(world.m_45976_(ItemEntity.class, range));
        all.addAll(world.m_45976_(ExperienceOrb.class, range));
        return all;
    }

    public static boolean speedupEntityIfMoving(LivingEntity entity, float factor) {
        if (entity.f_20902_ > 0.0f) {
            if (entity.m_20202_() != null && entity.m_20202_() instanceof LivingEntity) {
                EntityUtil.speedupEntity((LivingEntity)entity.m_20202_(), factor);
                return true;
            }
            EntityUtil.speedupEntity(entity, factor);
            return true;
        }
        return false;
    }

    public static void speedupEntity(LivingEntity entity, float factor) {
        float x = Mth.m_14031_((float)(-entity.m_146908_() * ((float)Math.PI / 180))) * factor;
        float z = Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180))) * factor;
        entity.m_20334_((double)x, entity.m_20184_().f_82480_, (double)z);
    }

    public static int pullEntityList(double x, double y, double z, boolean towardsPos, List<? extends Entity> all) {
        return EntityUtil.pullEntityList(x, y, z, towardsPos, all, 0.2f, 0.9f);
    }

    public static int pullEntityList(double x, double y, double z, boolean towardsPos, List<? extends Entity> all, float speedClose, float speedFar) {
        int moved = 0;
        int direction = towardsPos ? 1 : -1;
        for (Entity entity : all) {
            double zDist;
            BlockPos p;
            double xDist;
            double hdist;
            if (entity == null || entity instanceof Player && ((Player)entity).m_6047_() || !((hdist = Math.sqrt((xDist = Math.abs(x - (double)(p = entity.m_142538_()).m_123341_())) * xDist + (zDist = Math.abs(z - (double)p.m_123343_())) * zDist)) > 0.4)) continue;
            float speed = hdist > 3.0 ? speedFar : speedClose;
            EntityUtil.setEntityMotionFromVector(entity, x, y, z, (float)direction * speed);
            ++moved;
        }
        return moved;
    }

    public static void setEntityMotionFromVector(Entity entity, double x, double y, double z, float modifier) {
        Vector3 originalPosVector = new Vector3(x, y, z);
        Vector3 entityVector = new Vector3(entity);
        Vector3 finalVector = originalPosVector.copy().subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector.normalize();
        }
        double motionX = finalVector.x * (double)modifier;
        double motionY = finalVector.y * (double)modifier;
        double motionZ = finalVector.z * (double)modifier;
        entity.m_20334_(motionX, motionY, motionZ);
    }

    public static void addOrMergePotionEffect(LivingEntity player, MobEffectInstance newp) {
        if (player.m_21023_(newp.m_19544_())) {
            MobEffectInstance p = player.m_21124_(newp.m_19544_());
            int ampMax = Math.max(p.m_19564_(), newp.m_19564_());
            int dur = newp.m_19557_() + p.m_19557_();
            player.m_7292_(new MobEffectInstance(newp.m_19544_(), dur, ampMax));
        } else {
            player.m_7292_(newp);
        }
    }

    public static void centerEntityHoriz(Entity entity, BlockPos pos) {
        float fixedX = (float)pos.m_123341_() + 0.5f;
        float fixedZ = (float)pos.m_123343_() + 0.5f;
        entity.m_6034_((double)fixedX, (double)entity.m_142538_().m_123342_(), (double)fixedZ);
    }

    public static List<Villager> getVillagers(Level world, BlockPos p, int r) {
        BlockPos start = p.m_142082_(-r, -r, -r);
        BlockPos end = p.m_142082_(r, r, r);
        return world.m_45976_(Villager.class, new AABB(start, end));
    }

    public static LivingEntity getClosestEntity(Level world, Player player, List<? extends LivingEntity> list) {
        LivingEntity closest = null;
        double minDist = 999999.0;
        for (LivingEntity livingEntity : list) {
            double zDistance;
            double xDistance = Math.abs(player.f_19854_ - livingEntity.f_19854_);
            double dist = Math.sqrt(xDistance * xDistance + (zDistance = Math.abs(player.f_19856_ - livingEntity.f_19856_)) * zDistance);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = livingEntity;
        }
        return closest;
    }

    public static Villager getVillager(Level world, int x, int y, int z) {
        List all = world.m_45976_(Villager.class, new AABB(new BlockPos(x, y, z)));
        if (all.size() == 0) {
            return null;
        }
        return (Villager)all.get(0);
    }

    public static float yawDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        return f;
    }

    public static float pitchDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        return (float)Math.toDegrees(Math.atan2(posY2 - posY, Math.sqrt((posX2 - posX) * (posX2 - posX) + (posZ2 - posZ) * (posZ2 - posZ))));
    }

    public static Vec3 lookVector(float rotYaw, float rotPitch) {
        return new Vec3(Math.sin(rotYaw) * Math.cos(rotPitch), Math.sin(rotPitch), Math.cos(rotYaw) * Math.cos(rotPitch));
    }

    public static float getYawFromFacing(Direction currentFacing) {
        switch (currentFacing) {
            default: {
                return 0.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case WEST: 
        }
        return 90.0f;
    }

    public static void setEntityFacing(LivingEntity entity, Direction currentFacing) {
        float yaw = 0.0f;
        switch (currentFacing) {
            case EAST: {
                yaw = 270.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
                break;
            }
            default: {
                yaw = 0.0f;
            }
        }
        entity.m_146922_(yaw);
    }

    public static void dragEntityMomentum(LivingEntity entity, double verticalMomentumFactor) {
        double x = entity.m_20184_().f_82479_ / verticalMomentumFactor;
        double z = entity.m_20184_().f_82481_ / verticalMomentumFactor;
        entity.m_20334_(x, entity.m_20184_().f_82480_, z);
    }

    public static void setCooldownItem(Player player, Item item, int cooldown) {
        player.m_36335_().m_41524_(item, cooldown);
    }

    public static Attribute getAttributeJump(Horse ahorse) {
        return Attributes.f_22288_;
    }

    public static void eatingHorse(Horse ahorse) {
        ahorse.m_30610_();
    }

    public static void tryMakeEntityClimb(Level worldIn, LivingEntity entity, double climbSpeed) {
        if (entity.m_6047_()) {
            entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
        } else if (entity.f_20902_ > 0.0f && entity.m_20184_().f_82480_ < climbSpeed) {
            entity.m_20334_(entity.m_20184_().f_82479_, climbSpeed, entity.m_20184_().f_82481_);
            entity.f_19789_ = 0.0f;
        }
        if (worldIn.f_46443_ && entity.f_19797_ % 22 == 0) {
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketPlayerFalldamage());
        }
    }

    public static void dimensionTeleport(ServerPlayer player, ServerLevel world, BlockPosDim loc) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (!player.m_6072_()) {
            return;
        }
        if (!world.f_46443_) {
            DimensionTransit transit = new DimensionTransit(world, loc);
            transit.teleport((Player)player);
            player.changeDimension(transit.getTargetLevel(), (ITeleporter)transit);
        }
    }
}

