/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.module;

import com.lothrazar.library.FutureLibMod;
import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.module.ConfigModule;
import com.lothrazar.library.util.AttributesUtil;
import com.lothrazar.library.util.ChatUtil;
import com.lothrazar.library.util.EntityUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommandModule {
    public static final Random RAND = new Random();
    private static final String FORK_RESET = "reset";
    private static final String FORK_FACTOR = "factor";
    private static final String FORK_ADD = "add";
    private static final String FORK_SET = "set";
    private static final String FORK_RANDOM = "random";
    private static final String ARG_OBJECTIVE = "objective";
    private static final String ARG_TARGETS = "targets";
    private static final String ARG_ATTR = "attribute";
    private static final String ARG_MIN = "min";
    private static final String ARG_MAX = "max";
    private static final String ARG_VALUE = "value";
    private static final String ARG_PLAYER = "player";
    public static final int PERM_EVERYONE = 0;
    public static final int PERM_ELEVATED = 2;

    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        if (!((Boolean)ConfigModule.ENABLE_COMMANDS.get()).booleanValue()) {
            FutureLibMod.LOGGER.info("Disabling command /flib from feature instance");
            return;
        }
        CommandDispatcher r = event.getDispatcher();
        r.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"flib").then(((LiteralArgumentBuilder)Commands.m_82127_((String)SubCommands.OVERRIDE.toString()).requires(p -> p.m_6761_(1))).then(Commands.m_82129_((String)"corefeature", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)BoolArgumentType.bool()).executes(x -> {
            FutureLibMod.LOGGER.error("/flib override test command ");
            return 0;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)SubCommands.TPX.toString()).requires(p -> p.m_6761_(2))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"z", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"p", (ArgumentType)EntityArgument.m_91470_()).executes(x -> {
            FutureLibMod.LOGGER.info("flib test " + x.getSource());
            CommandModule.tpx((CommandContext<CommandSourceStack>)x, DimensionArgument.m_88808_((CommandContext)x, (String)"dim"), new BlockPos(IntegerArgumentType.getInteger((CommandContext)x, (String)"x"), IntegerArgumentType.getInteger((CommandContext)x, (String)"y"), IntegerArgumentType.getInteger((CommandContext)x, (String)"z")), EntityArgument.m_91477_((CommandContext)x, (String)"p"));
            return 0;
        })))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)SubCommands.HEALTH.toString()).requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)FORK_SET).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(x -> CommandHealth.executeSet((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), FloatArgumentType.getFloat((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_ADD).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)IntegerArgumentType.integer()).executes(x -> CommandHealth.executeAdd((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_FACTOR).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10.0)).executes(x -> CommandHealth.executeFactor((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), DoubleArgumentType.getDouble((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_RANDOM).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_MIN, (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).then(Commands.m_82129_((String)ARG_MAX, (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).executes(x -> CommandHealth.addRandom((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MIN), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MAX))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)SubCommands.HUNGER.toString()).requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)FORK_FACTOR).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10.0)).executes(x -> CommandHunger.executeFactor((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), DoubleArgumentType.getDouble((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_ADD).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).executes(x -> CommandHunger.executeAdd((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_SET).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(x -> CommandHunger.executeSet((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_RANDOM).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_MIN, (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).then(Commands.m_82129_((String)ARG_MAX, (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).executes(x -> CommandHunger.executeRandom((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MIN), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MAX))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)SubCommands.HEARTS.toString()).requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)FORK_SET).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)IntegerArgumentType.integer()).executes(x -> AttributesUtil.setHearts(EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_ADD).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)IntegerArgumentType.integer()).executes(x -> AttributesUtil.add(Attributes.f_22276_, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_FACTOR).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10.0)).executes(x -> AttributesUtil.multiply(Attributes.f_22276_, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), DoubleArgumentType.getDouble((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_RANDOM).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_MIN, (ArgumentType)IntegerArgumentType.integer((int)-100, (int)100)).then(Commands.m_82129_((String)ARG_MAX, (ArgumentType)IntegerArgumentType.integer((int)-100, (int)100)).executes(x -> AttributesUtil.addRandom(Attributes.f_22276_, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MIN), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MAX))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)SubCommands.SCOREBOARD.toString()).requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)FORK_RANDOM).then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)ScoreHolderArgument.m_108239_()).then(Commands.m_82129_((String)ARG_MIN, (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)ARG_MAX, (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)ARG_OBJECTIVE, (ArgumentType)StringArgumentType.greedyString()).executes(x -> CommandScoreboard.scoreboardRng((CommandContext<CommandSourceStack>)x, ScoreHolderArgument.m_108246_((CommandContext)x, (String)ARG_TARGETS), ObjectiveArgument.m_101960_((CommandContext)x, (String)ARG_OBJECTIVE), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MIN), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MAX))))))))).then(Commands.m_82127_((String)FORK_ADD).then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)ScoreHolderArgument.m_108239_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)ARG_OBJECTIVE, (ArgumentType)ObjectiveArgument.m_101957_()).executes(x -> CommandScoreboard.scoreboardAdd((CommandContext<CommandSourceStack>)x, ScoreHolderArgument.m_108246_((CommandContext)x, (String)ARG_TARGETS), ObjectiveArgument.m_101960_((CommandContext)x, (String)ARG_OBJECTIVE), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_VALUE)))))))).then(Commands.m_82127_((String)"test").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)ScoreHolderArgument.m_108239_()).then(Commands.m_82129_((String)ARG_OBJECTIVE, (ArgumentType)ObjectiveArgument.m_101957_()).executes(x -> CommandScoreboard.scoreboardRngTest((CommandContext<CommandSourceStack>)x, ScoreHolderArgument.m_108246_((CommandContext)x, (String)ARG_TARGETS), ObjectiveArgument.m_101960_((CommandContext)x, (String)ARG_OBJECTIVE)))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)SubCommands.GAMEMODE.toString()).requires(p -> p.m_6761_(2))).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(x -> CommandModule.executeGamemode((CommandContext<CommandSourceStack>)x, EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_VALUE))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)SubCommands.ATTRIBUTE.toString()).requires(p -> p.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)ARG_ATTR, (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registry.f_122916_)).then(Commands.m_82127_((String)FORK_ADD).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)IntegerArgumentType.integer((int)-10000, (int)10000)).executes(x -> AttributesUtil.add(ResourceKeyArgument.m_212370_((CommandContext)x, (String)ARG_ATTR), EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_RANDOM).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_MIN, (ArgumentType)IntegerArgumentType.integer((int)-10000, (int)10000)).then(Commands.m_82129_((String)ARG_MAX, (ArgumentType)IntegerArgumentType.integer((int)-10000, (int)10000)).executes(x -> AttributesUtil.addRandom(ResourceKeyArgument.m_212370_((CommandContext)x, (String)ARG_ATTR), EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MIN), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_MAX)))))))).then(Commands.m_82127_((String)FORK_FACTOR).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_VALUE, (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(x -> AttributesUtil.multiply(ResourceKeyArgument.m_212370_((CommandContext)x, (String)ARG_ATTR), EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER), DoubleArgumentType.getDouble((CommandContext)x, (String)ARG_VALUE))))))).then(Commands.m_82127_((String)FORK_RESET).then(Commands.m_82129_((String)ARG_PLAYER, (ArgumentType)EntityArgument.m_91470_()).executes(x -> AttributesUtil.reset(ResourceKeyArgument.m_212370_((CommandContext)x, (String)ARG_ATTR), EntityArgument.m_91477_((CommandContext)x, (String)ARG_PLAYER))))))));
    }

    public static int executeGamemode(CommandContext<CommandSourceStack> x, Collection<ServerPlayer> players, int integer) {
        block6: for (ServerPlayer p : players) {
            switch (integer) {
                case 0: {
                    p.m_143403_(GameType.SURVIVAL);
                    continue block6;
                }
                case 1: {
                    p.m_143403_(GameType.CREATIVE);
                    continue block6;
                }
                case 2: {
                    p.m_143403_(GameType.ADVENTURE);
                    continue block6;
                }
                case 3: {
                    p.m_143403_(GameType.SPECTATOR);
                    continue block6;
                }
            }
            ChatUtil.sendFeedback(x, integer + " = ?!");
        }
        return 0;
    }

    private static void tpx(CommandContext<CommandSourceStack> x, ServerLevel dimension, BlockPos pos, Collection<ServerPlayer> players) {
        if (dimension == null || pos == null || players == null) {
            return;
        }
        for (ServerPlayer p : players) {
            EntityUtil.dimensionTeleport(p, dimension, new BlockPosDim(pos, (Level)dimension));
        }
    }

    public static enum SubCommands {
        TPX,
        HEALTH,
        HUNGER,
        HEARTS,
        GAMEMODE,
        SCOREBOARD,
        ATTRIBUTE,
        OVERRIDE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static class CommandScoreboard {
        public static int scoreboardRngTest(CommandContext<CommandSourceStack> x, Collection<String> scoreHolderTargets, Objective objective) {
            ServerScoreboard scoreboard = ((CommandSourceStack)x.getSource()).m_81377_().m_129896_();
            int i = 0;
            for (String s : scoreHolderTargets) {
                Score score = scoreboard.m_83471_(s, objective);
                i += score.m_83400_();
            }
            return i;
        }

        public static int scoreboardAdd(CommandContext<CommandSourceStack> x, Collection<String> scoreHolderTargets, Objective objective, int integer) {
            ServerScoreboard scoreboard = ((CommandSourceStack)x.getSource()).m_81377_().m_129896_();
            int i = 0;
            for (String s : scoreHolderTargets) {
                Score score = scoreboard.m_83471_(s, objective);
                score.m_83393_(integer);
                i += score.m_83400_();
            }
            return i;
        }

        public static int scoreboardRng(CommandContext<CommandSourceStack> x, Collection<String> scoreHolderTargets, Objective objective, int min, int max) {
            ServerScoreboard scoreboard = ((CommandSourceStack)x.getSource()).m_81377_().m_129896_();
            int i = 0;
            for (String s : scoreHolderTargets) {
                Score score = scoreboard.m_83471_(s, objective);
                if (min < max) {
                    score.m_83402_(RAND.nextInt(min, max));
                } else {
                    score.m_83402_(min);
                }
                i += score.m_83400_();
            }
            return i;
        }
    }

    public static class CommandHunger {
        private static void set(int newlevel, ServerPlayer player) {
            player.m_36324_().m_38705_(newlevel);
        }

        private static int get(ServerPlayer player) {
            return player.m_36324_().m_38702_();
        }

        public static int executeSet(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, int newlevel) {
            for (ServerPlayer player : players) {
                CommandHunger.set(newlevel, player);
            }
            return 0;
        }

        public static int executeRandom(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, int min, int max) {
            for (ServerPlayer player : players) {
                CommandHunger.set(RAND.nextInt(min, max), player);
            }
            return 0;
        }

        public static int executeFactor(CommandContext<CommandSourceStack> x, Collection<ServerPlayer> players, double fact) {
            for (ServerPlayer player : players) {
                CommandHunger.set((int)((double)CommandHunger.get(player) * fact), player);
            }
            return 0;
        }

        public static int executeAdd(CommandContext<CommandSourceStack> x, Collection<ServerPlayer> players, int more) {
            for (ServerPlayer player : players) {
                CommandHunger.set(CommandHunger.get(player) + more, player);
            }
            return 0;
        }
    }

    public static class CommandHealth {
        private static void set(float newlevel, ServerPlayer player) {
            player.m_21153_(newlevel);
        }

        private static float get(ServerPlayer player) {
            return player.m_21223_();
        }

        public static int executeSet(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, float newlevel) {
            for (ServerPlayer player : players) {
                CommandHealth.set(newlevel, player);
            }
            return 0;
        }

        public static int executeAdd(CommandContext<CommandSourceStack> x, Collection<ServerPlayer> players, int more) {
            for (ServerPlayer player : players) {
                CommandHealth.set(CommandHealth.get(player) + (float)more, player);
            }
            return 0;
        }

        public static int executeFactor(CommandContext<CommandSourceStack> x, Collection<ServerPlayer> players, double factor) {
            for (ServerPlayer player : players) {
                CommandHealth.set(CommandHealth.get(player) * (float)factor, player);
            }
            return 0;
        }

        public static int addRandom(CommandContext<CommandSourceStack> x, Collection<ServerPlayer> players, int min, int max) {
            for (ServerPlayer player : players) {
                CommandHealth.set(CommandHealth.get(player) + (float)RAND.nextInt(min, max), player);
            }
            return 0;
        }
    }
}

