/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.item;

import com.lothrazar.library.util.ItemStackUtil;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemFlib
extends Item {
    public static final int COLOUR_RF_BAR = 12192009;
    public static final float INACCURACY_DEFAULT = 1.0f;
    public static final float VELOCITY_MAX = 1.5f;
    private Settings me;

    public ItemFlib(Item.Properties prop, Settings custom) {
        super(prop);
        this.me = custom;
    }

    public ItemFlib(Item.Properties prop) {
        this(prop, new Settings());
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return this.me.burnTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.me.tooltip) {
            this.me.tooltipApply(this, tooltip);
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public void tryRepairWith(ItemStack stackToRepair, Player player, Item target) {
        ItemStack torches;
        if (stackToRepair.m_41768_() && !(torches = this.findAmmo(player, target)).m_41619_()) {
            torches.m_41774_(1);
            ItemStackUtil.repairItem(stackToRepair);
        }
    }

    protected void shootMe(Level world, Player shooter, Projectile ball, float pitch, float velocityFactor) {
        if (world.f_46443_) {
            return;
        }
        Vec3 vector3d1 = shooter.m_20289_(1.0f);
        Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), pitch, true);
        Vec3 vector3d = shooter.m_20252_(1.0f);
        Vector3f vector3f = new Vector3f(vector3d);
        vector3f.m_122251_(quaternion);
        ball.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), velocityFactor * 1.5f, 1.0f);
        world.m_7967_((Entity)ball);
    }

    protected ItemStack findAmmo(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (itemstack.m_41720_() != item) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public float getChargedPercent(ItemStack stack, int chargeTimer) {
        return BowItem.m_40661_((int)(this.m_8105_(stack) - chargeTimer));
    }

    public static class Settings {
        boolean tooltip = false;
        int burnTime = 0;

        public Settings tooltip() {
            this.tooltip = true;
            return this;
        }

        public Settings noTooltip() {
            this.tooltip = false;
            return this;
        }

        public Settings burnTime(int burnTicks) {
            this.burnTime = Math.max(0, burnTicks);
            return this;
        }

        public void tooltipApply(Item block, List<Component> tooltipList) {
            tooltipList.add((Component)new TranslatableComponent(block.m_5524_() + ".tooltip").m_130940_(ChatFormatting.GRAY));
        }
    }
}

