/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class EnergyBar {
    public static final ResourceLocation ENERGY_BAR = new ResourceLocation("flib", "textures/gui/energy_bar.png");
    private Screen parent;
    private int x = 154;
    private int y = 8;
    public int capacity;
    private int width = 16;
    private int height = 62;
    public int guiLeft;
    public int guiTop;
    public boolean visible = true;

    public EnergyBar(Screen parent, int cap) {
        this.parent = parent;
        this.capacity = cap;
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x < mouseX && mouseX < this.guiLeft + this.x + this.width && this.guiTop + this.y < mouseY && mouseY < this.guiTop + this.y + this.getHeight();
    }

    public void draw(PoseStack ms, float energ) {
        if (!this.visible) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ENERGY_BAR);
        int relX = this.guiLeft + this.x;
        int relY = this.guiTop + this.y;
        Screen.m_93133_((PoseStack)ms, (int)relX, (int)relY, (float)16.0f, (float)0.0f, (int)this.width, (int)this.getHeight(), (int)32, (int)this.getHeight());
        float pct = Math.min(energ / (float)this.capacity, 1.0f);
        Screen.m_93133_((PoseStack)ms, (int)relX, (int)relY, (float)0.0f, (float)0.0f, (int)this.width, (int)(this.getHeight() - (int)((float)this.getHeight() * pct)), (int)32, (int)this.getHeight());
    }

    public void renderHoveredToolTip(PoseStack ms, int mouseX, int mouseY, int energ) {
        if (this.visible && this.isMouseover(mouseX, mouseY)) {
            String tt = energ + "/" + this.capacity;
            ArrayList<TranslatableComponent> list = new ArrayList<TranslatableComponent>();
            list.add(new TranslatableComponent(tt));
            this.parent.m_96597_(ms, list, mouseX, mouseY);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

