/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.events;

import com.lothrazar.library.FutureLibMod;
import com.lothrazar.library.cap.player.PlayerCapProvider;
import com.lothrazar.library.cap.player.PlayerCapabilityStorage;
import com.lothrazar.library.cap.world.FlibWorldSavedData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilityEvents {
    public CapabilityEvents() {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityEvents::onAttachCapabilitiesPlayer);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.f_46443_) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        FlibWorldSavedData manager = FlibWorldSavedData.get(event.world);
        manager.onWorldTick(event.world);
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerCapProvider.CYCLIC_PLAYER).ifPresent(oldStore -> event.getPlayer().getCapability(PlayerCapProvider.CYCLIC_PLAYER).ifPresent(newStore -> newStore.copyFrom((PlayerCapabilityStorage)oldStore)));
        }
    }

    @SubscribeEvent
    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerCapabilityStorage.class);
        FutureLibMod.LOGGER.info("RegisterCapabilitiesEvent success for ManaManager");
    }

    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerCapProvider.CYCLIC_PLAYER).isPresent()) {
            event.addCapability(new ResourceLocation("flib", "data"), (ICapabilityProvider)new PlayerCapProvider());
            FutureLibMod.LOGGER.info("CapabilityRegistry success for data");
        }
    }
}

