/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.cap.player;

import com.lothrazar.library.cap.player.PlayerCapabilityStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerCapProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PlayerCapabilityStorage> CYCLIC_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerCapabilityStorage>(){});
    private PlayerCapabilityStorage playerMana = null;
    private final LazyOptional<PlayerCapabilityStorage> opt = LazyOptional.of(this::createMe);

    @Nonnull
    private PlayerCapabilityStorage createMe() {
        if (this.playerMana == null) {
            this.playerMana = new PlayerCapabilityStorage();
        }
        return this.playerMana;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CYCLIC_PLAYER) {
            return this.opt.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.createMe().saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createMe().loadNBTData(nbt);
    }
}

