/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.cap.item;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidHandlerCapabilityStack
implements IFluidHandlerItem,
ICapabilityProvider {
    public static final String FLUID_NBT_KEY = "Fluid";
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    protected ItemStack container;
    protected int capacity;

    public FluidHandlerCapabilityStack(ItemStack container, int capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public FluidStack getFluid() {
        CompoundTag tagCompound = this.container.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_(FLUID_NBT_KEY)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound.m_128469_(FLUID_NBT_KEY));
    }

    public void setFluid(FluidStack fluid) {
        if (!this.container.m_41782_()) {
            this.container.m_41751_(new CompoundTag());
        }
        CompoundTag fluidTag = new CompoundTag();
        fluid.writeToNBT(fluidTag);
        this.container.m_41783_().m_128365_(FLUID_NBT_KEY, (Tag)fluidTag);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.capacity, resource.getAmount());
            if (doFill.execute()) {
                FluidStack filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.capacity - contained.getAmount(), resource.getAmount());
            if (doFill.execute() && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !resource.isFluidEqual(this.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty() || !this.canDrainFluidType(contained)) {
            return FluidStack.EMPTY;
        }
        int drainAmount = Math.min(contained.getAmount(), maxDrain);
        FluidStack drained = contained.copy();
        drained.setAmount(drainAmount);
        if (action.execute()) {
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return true;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return true;
    }

    protected void setContainerToEmpty() {
        this.container.m_41749_(FLUID_NBT_KEY);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == capability) {
            return this.holder.cast();
        }
        return LazyOptional.empty();
    }
}

