/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.cap.item;

import com.lothrazar.library.cap.CustomEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCapabilityItemStack
implements ICapabilityProvider {
    public static final String NBTENERGY = "energy";
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private int max;
    private ItemStack stack;

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.max, this.max / 4){

            public int getEnergyStored() {
                if (EnergyCapabilityItemStack.this.stack.m_41782_()) {
                    return EnergyCapabilityItemStack.this.stack.m_41783_().m_128451_(EnergyCapabilityItemStack.NBTENERGY);
                }
                return super.getEnergyStored();
            }

            @Override
            public void setEnergy(int energy) {
                if (!EnergyCapabilityItemStack.this.stack.m_41782_()) {
                    EnergyCapabilityItemStack.this.stack.m_41751_(new CompoundTag());
                }
                EnergyCapabilityItemStack.this.stack.m_41783_().m_128405_(EnergyCapabilityItemStack.NBTENERGY, energy);
                super.setEnergy(energy);
            }
        };
    }

    public EnergyCapabilityItemStack(ItemStack stack, int capacity) {
        this.max = capacity;
        this.stack = stack;
        this.energy = LazyOptional.of(this::createEnergy);
    }

    public String toString() {
        return "EnergyCapabilityItemStack [energy=" + this.energy + ", max=" + this.max + "]";
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (CapabilityEnergy.ENERGY == capability) {
            return this.energy.cast();
        }
        return LazyOptional.empty();
    }
}

