/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class TeleportMessage {
    ResourceKey<Level> origin;
    ResourceKey<Level> dest;
    BlockPos pos;

    public TeleportMessage(ResourceKey<Level> origin, ResourceKey<Level> dest, BlockPos pos) {
        this.origin = origin;
        this.dest = dest;
        this.pos = pos;
    }

    public static void encode(TeleportMessage data, FriendlyByteBuf buf) {
        NetworkTools.writeWorldKey(data.origin, buf);
        NetworkTools.writeWorldKey(data.dest, buf);
        buf.m_130064_(data.pos);
    }

    public static TeleportMessage decode(FriendlyByteBuf buf) {
        return new TeleportMessage(NetworkTools.readWorldKey(buf), NetworkTools.readWorldKey(buf), buf.m_130135_());
    }

    public static void handle(TeleportMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (!player.m_20310_(2)) {
                return;
            }
            ServerLevel ori = player.m_20194_().m_129880_(data.origin);
            ServerLevel dest = player.m_20194_().m_129880_(data.dest);
            WorldUtils.teleportPlayer((Player)player, (Level)ori, (Level)dest, data.pos);
        });
        ctx.get().setPacketHandled(true);
    }
}

