/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.Screens.CUOption;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;

public class LoadedChunkData {
    Map<String, Set<ChunkPos>> chunksByTicketName = new HashMap<String, Set<ChunkPos>>();
    Map<String, Set<ChunkPos>> chunksByLocationType = new HashMap<String, Set<ChunkPos>>();
    Map<ChunkPos, Set<String>> ticketsByChunk = new HashMap<ChunkPos, Set<String>>();
    Map<ChunkPos, String> locationTypeByChunk = new HashMap<ChunkPos, String>();
    Map<String, LocationTickets> ticketsByLocation = new HashMap<String, LocationTickets>();
    int total = 0;

    public Map<String, Set<ChunkPos>> getChunksByTicketName() {
        return this.chunksByTicketName;
    }

    public Map<String, Set<ChunkPos>> getChunksByLocationType() {
        return this.chunksByLocationType;
    }

    public LoadedChunkData(Map<String, Set<ChunkPos>> chunksByTicketName, Map<String, Set<ChunkPos>> chunksByLocationType) {
        this.chunksByTicketName = chunksByTicketName;
        this.chunksByLocationType = chunksByLocationType;
    }

    public LoadedChunkData(List<ServerLevel> worlds) {
        CrashUtils.runNextTick(world -> this.init(worlds));
    }

    public void init(List<ServerLevel> worlds) {
        for (Level level : worlds) {
            ChunkMap chunkManager = ((ServerChunkCache)level.m_7726_()).f_8325_;
            DistanceManager ticketManager = chunkManager.m_143145_();
            this.total += chunkManager.m_140394_();
            Iterable chunkHolders = chunkManager.m_140416_();
            chunkHolders.forEach(chunkHolder -> {
                ChunkAccess chunk = chunkHolder.m_140089_();
                LocationTickets ticketCounter = null;
                if (chunk == null) {
                    this.chunksByLocationType.merge("PRIMED", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.m_140092_())), (list, newer) -> {
                        list.add(chunkHolder.m_140092_());
                        return list;
                    });
                    this.ticketsByLocation.merge("PRIMED", new LocationTickets(), (x, y) -> {
                        ++x.count;
                        return x;
                    });
                    ticketCounter = this.ticketsByLocation.get("PRIMED");
                } else if (chunk instanceof LevelChunk) {
                    LevelChunk actualChunk = (LevelChunk)chunk;
                    this.chunksByLocationType.merge(actualChunk.m_6708_().toString(), new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.m_140092_())), (list, newer) -> {
                        list.add(chunkHolder.m_140092_());
                        return list;
                    });
                    this.ticketsByLocation.merge(actualChunk.m_6708_().toString(), new LocationTickets(), (x, y) -> {
                        ++x.count;
                        return x;
                    });
                    ticketCounter = this.ticketsByLocation.get(actualChunk.m_6708_().toString());
                } else if (chunk instanceof ProtoChunk) {
                    this.chunksByLocationType.merge(chunk.m_6415_().m_62467_().equals("full") ? "FULL" : "PARTIALLYGENERATED", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.m_140092_())), (list, newer) -> {
                        list.add(chunkHolder.m_140092_());
                        return list;
                    });
                    this.ticketsByLocation.merge(chunk.m_6415_().m_62467_().equals("full") ? "FULL" : "PARTIALLYGENERATED", new LocationTickets(), (x, y) -> {
                        ++x.count;
                        return x;
                    });
                    ticketCounter = this.ticketsByLocation.get(chunk.m_6415_().m_62467_().equals("full") ? "FULL" : "PARTIALLYGENERATED");
                }
                SortedArraySet tickets = ticketManager.m_140857_(chunkHolder.m_140092_().m_45588_());
                if (tickets.isEmpty()) {
                    this.chunksByTicketName.merge("no_ticket", new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.m_140092_())), (old, nothing) -> {
                        old.add(chunkHolder.m_140092_());
                        return old;
                    });
                } else {
                    for (Ticket ticket : tickets) {
                        this.chunksByTicketName.merge(ticket.m_9428_().toString(), new HashSet<ChunkPos>(Collections.singletonList(chunkHolder.m_140092_())), (old, nothing) -> {
                            old.add(chunkHolder.m_140092_());
                            return old;
                        });
                        if (ticketCounter == null) continue;
                        ticketCounter.tickets.merge(ticket.m_9428_().toString(), 1, Integer::sum);
                    }
                }
            });
        }
    }

    public void reply(CommandSourceStack source) {
        this.ticketsByLocation.forEach((name, locationticket) -> {
            source.m_81354_((Component)new TextComponent(name + ": " + locationticket.count), true);
            locationticket.tickets.forEach((ticket, count) -> source.m_81354_((Component)new TextComponent("    " + ticket + ": " + count), true));
        });
        source.m_81354_((Component)new TextComponent("Non-Ticking chunks have little to no performance impact. See the GUI and minecraft wiki for what each type represents."), false);
    }

    public void replyWithLocation(CommandSourceStack source, String word) throws CommandSyntaxException {
        source.m_81354_((Component)new TextComponent("Chunks with LocationType " + word), true);
        Set<ChunkPos> chunkPos = this.chunksByLocationType.get(word);
        if (chunkPos != null) {
            this.sendChunkPositions(source, chunkPos);
        }
    }

    private void sendChunkPositions(CommandSourceStack source, Set<ChunkPos> chunks) throws CommandSyntaxException {
        for (ChunkPos chunkPos : chunks) {
            BlockPos pos = chunkPos.m_45615_();
            CommandUtils.sendCommandMessage(source, (MutableComponent)new TextComponent(chunkPos.toString()), "/cu tp " + (source.m_81373_() instanceof Player ? source.m_81375_().m_7755_().getString() : "Console") + " " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_(), true);
        }
    }

    public void replyWithTicket(CommandSourceStack source, String word) throws CommandSyntaxException {
        Set<ChunkPos> chunks = this.chunksByTicketName.get(word);
        if (chunks == null) {
            return;
        }
        source.m_81354_((Component)new TextComponent("Chunks with " + word + " Ticket"), true);
        this.sendChunkPositions(source, chunks);
    }

    public void createReverseMapping() {
        this.chunksByTicketName.forEach((x, y) -> y.forEach(t -> this.ticketsByChunk.merge((ChunkPos)t, (Set<String>)new HashSet<String>(Collections.singleton(x)), (old, n) -> {
            old.add(x);
            return old;
        })));
        this.chunksByLocationType.forEach((x, y) -> y.forEach(t -> this.locationTypeByChunk.put((ChunkPos)t, (String)x)));
    }

    public String getTickets(ChunkPos pos) {
        Set<String> strings = this.ticketsByChunk.get(pos);
        if (strings == null || strings.isEmpty()) {
            return null;
        }
        if (strings.size() > 1) {
            strings.remove("unknown");
        }
        StringBuilder toReturn = new StringBuilder();
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            toReturn.append(it.next());
            if (!it.hasNext()) continue;
            toReturn.append(", ");
        }
        return toReturn.toString();
    }

    public String getLocationType(ChunkPos pos) {
        return this.locationTypeByChunk.get(pos);
    }

    public List<CUOption> getTicketsAsDropdownOptions(String filter) {
        return this.getCuDropDownOptions(filter, this.chunksByTicketName);
    }

    public List<CUOption> getStatesAsDropdownOptions(String filter) {
        return this.getCuDropDownOptions(filter, this.chunksByLocationType);
    }

    private List<CUOption> getCuDropDownOptions(String filter, Map<String, Set<ChunkPos>> chunkMap) {
        ArrayList<CUOption> list = new ArrayList<CUOption>();
        if (filter.isEmpty()) {
            chunkMap.forEach((string, set) -> list.add(new CUOption((String)string, set.size())));
        } else {
            chunkMap.get(filter).forEach(chunkPos -> list.add(new CUOption((ChunkPos)chunkPos)));
        }
        return list;
    }

    private static class LocationTickets {
        int count;
        Map<String, Integer> tickets = new HashMap<String, Integer>();

        private LocationTickets() {
        }
    }
}

