/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.PlayerCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TeleportCommand
implements Command<CommandSourceStack> {
    private static final TeleportCommand cmd = new TeleportCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"tp").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes((Command)cmd)).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes((Command)cmd)))).then(Commands.m_82129_((String)"otherPlayer", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).executes((Command)cmd)));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        ServerLevel playerWorld = ((CommandSourceStack)context.getSource()).m_81372_();
        ServerLevel destWorld = null;
        String otherPlayerName = "";
        String playerName = "";
        BlockPos pos = null;
        try {
            destWorld = DimensionArgument.m_88808_(context, (String)"dim");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            otherPlayerName = StringArgumentType.getString(context, (String)"otherPlayer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pos = BlockPosArgument.m_118242_(context, (String)"pos");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (destWorld == null) {
            destWorld = playerWorld;
        }
        try {
            playerName = StringArgumentType.getString(context, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (playerName == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("player to teleport not specified"));
            return 0;
        }
        ServerPlayer otherPlayer = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(otherPlayerName);
        if (pos == null && !otherPlayerName.isEmpty()) {
            if (otherPlayer != null) {
                pos = new BlockPos(otherPlayer.m_20182_());
            } else {
                AtomicReference offlinePlayerPos = new AtomicReference();
                if (!WorldUtils.applyToPlayer(otherPlayerName, ((CommandSourceStack)context.getSource()).m_81377_(), fakePlayer -> offlinePlayerPos.set(new BlockPos(fakePlayer.m_20182_())))) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Unable to load target players data"));
                    return 0;
                }
                pos = (BlockPos)offlinePlayerPos.get();
            }
        }
        if ((player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName)) != null) {
            WorldUtils.teleportPlayer((Player)player, (Level)playerWorld, (Level)destWorld, pos);
        } else {
            ServerLevel finalDestWorld = destWorld;
            BlockPos finalPos = pos;
            if (!WorldUtils.applyToPlayer(playerName, ((CommandSourceStack)context.getSource()).m_81377_(), fakePlayer -> {
                fakePlayer.m_6034_((double)finalPos.m_123341_(), (double)finalPos.m_123342_(), (double)finalPos.m_123343_());
                fakePlayer.m_143425_(finalDestWorld);
            })) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Unable to read source player data"));
                return 0;
            }
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Teleported " + playerName + " to " + pos.toString()), true);
        return 1;
    }
}

