/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.DataStructures.WorldPos;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandUtils {
    public static final int PERMISSION_LEVEL = 2;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final SuggestionProvider<CommandSourceStack> PROFILEPROVIDER = (ctx, builder) -> SharedSuggestionProvider.m_82981_(((CommandSourceStack)ctx.getSource()).m_81377_().m_129927_().m_10977_(1000).map(e -> e.m_11028_().getName()), (SuggestionsBuilder)builder);

    public static void sendNormalMessage(CommandSourceStack source, String msg, ChatFormatting color) {
        TextComponent text = new TextComponent(msg);
        Style style = Style.f_131099_;
        text = text.m_6270_(style);
        text.m_130940_(color);
        source.m_81354_((Component)text, true);
    }

    public static void sendCommandMessage(CommandSourceStack source, MutableComponent text, String command, boolean runDirectly) {
        Style style = text.m_7383_();
        ClickEvent click = new ClickEvent(runDirectly ? ClickEvent.Action.RUN_COMMAND : ClickEvent.Action.SUGGEST_COMMAND, command);
        style = style.m_131146_(style.m_131142_(click));
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to execute \u00a76" + command + "\u00a7r"));
        style = style.m_131146_(style.m_131144_(hoverEvent));
        MutableComponent tex = text.m_6270_(style);
        source.m_81354_((Component)tex, false);
        LOGGER.info(text.getString() + " " + command);
    }

    public static void sendTEMessage(CommandSourceStack source, WorldPos worldPos, boolean runDirectly) {
        BlockPos pos = worldPos.pos;
        String position = " - [" + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + "]";
        MutableComponent text = new TextComponent(position).m_130940_(ChatFormatting.GREEN);
        ServerPlayer player = null;
        try {
            player = source.m_81375_();
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        CommandUtils.sendCommandMessage(source, text, "/cu tp " + (player != null ? player.m_7755_().getString() : "Console") + " " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + " " + worldPos.type.m_135782_(), runDirectly);
    }

    public static void sendFindTEMessage(CommandSourceStack source, ResourceLocation res, int count, boolean ticking) {
        MutableComponent text = new TextComponent(res.toString()).m_130940_(ChatFormatting.AQUA);
        text.m_7220_((Component)new TextComponent(" Count ").m_130940_(ChatFormatting.DARK_RED));
        text.m_7220_((Component)new TextComponent(Integer.toString(count)).m_130940_(ChatFormatting.GREEN));
        if (ticking) {
            text.m_7220_((Component)new TextComponent(" ticking").m_130940_(ChatFormatting.RED));
        }
        CommandUtils.sendCommandMessage(source, text, "/cu tileentities find " + res.toString(), true);
    }

    public static void sendChunkEntityMessage(CommandSourceStack source, int count, BlockPos pos, ResourceKey<Level> type, boolean runDirectly) {
        MutableComponent text = new TextComponent("- " + pos.toString()).m_130940_(ChatFormatting.GREEN);
        text.m_7220_((Component)CommandUtils.coloredComponent(" Count ", ChatFormatting.RED));
        text.m_7220_((Component)CommandUtils.coloredComponent(Integer.toString(count), ChatFormatting.GREEN));
        ServerPlayer player = null;
        try {
            player = source.m_81375_();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        CommandUtils.sendCommandMessage(source, text, "/cu tp " + (player != null ? player.m_7755_().getString() : "Console") + " " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + " " + type.m_135782_(), runDirectly);
    }

    public static void sendFindEMessage(CommandSourceStack source, ResourceLocation res, int count) {
        MutableComponent text = new TextComponent(String.valueOf(count)).m_130940_(ChatFormatting.BLUE);
        text.m_7220_((Component)new TextComponent("x ").m_130940_(ChatFormatting.YELLOW));
        text.m_7220_((Component)new TextComponent(res.toString()).m_130940_(ChatFormatting.AQUA));
        CommandUtils.sendCommandMessage(source, text, "/cu entities find " + res.toString(), true);
    }

    public static MutableComponent coloredComponent(String text, ChatFormatting color) {
        return new TextComponent(text).m_130940_(color);
    }

    public static void sendItemInventoryRemovalMessage(CommandSourceStack source, String name, ItemStack itemStack, String inventoryType, int i) {
        MutableComponent text = new TextComponent("[" + i + "] ").m_130940_(ChatFormatting.DARK_BLUE);
        text.m_7220_(itemStack.m_41611_());
        String Command = "/cu inventory remove " + name + " " + inventoryType + " " + i;
        CommandUtils.sendCommandMessage(source, text, Command, false);
    }

    public static MutableComponent createURLComponent(String display, String url) {
        TextComponent text = new TextComponent(display);
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Go to " + url));
        Style style = Style.f_131099_;
        style = style.m_131146_(style.m_131142_(clickEvent));
        style = style.m_131146_(style.m_131144_(hoverEvent));
        text.m_6270_(style);
        return text;
    }

    public static MutableComponent createCopyComponent(String display, String toCopy) {
        TextComponent text = new TextComponent(display);
        Style style = Style.f_131099_;
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, toCopy);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Copy Contents to Clipboard"));
        style = style.m_131146_(style.m_131142_(clickEvent));
        style = style.m_131146_(style.m_131144_(hoverEvent));
        text.m_6270_(style);
        text.m_130940_(ChatFormatting.GREEN);
        return text;
    }

    public static MutableComponent getCommandTextComponent(String display, String command) {
        TextComponent text = new TextComponent(display);
        Style style = Style.f_131099_;
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to execute \u00a76" + command + "\u00a7r"));
        style = style.m_131146_(style.m_131142_(clickEvent));
        style = style.m_131146_(style.m_131144_(hoverEvent));
        text.m_6270_(style);
        text.m_130940_(ChatFormatting.GOLD);
        return text;
    }
}

