/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;
import shetiphian.core.common.NBTFile;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.common.misc.ChestData;
import shetiphian.enderchests.common.misc.LocationManager;

public class ChestHelper {
    public static final ChestHelper INSTANCE = new ChestHelper();
    private static final Table<String, String, ChestData> DATABASE = HashBasedTable.create();
    private static final Table<String, String, ChestData> CLIENT_CACHE = HashBasedTable.create();
    static boolean needsSaving = false;
    private static boolean isLoaded = false;
    private static String saveDir = null;
    private static final DateTimeFormatter dateTime = DateTimeFormatter.ofPattern("yy-MM-dd-HH-mm");

    private static ChestData getChestData(String owner, String code, boolean isClient) {
        ChestData chestData = isClient ? (ChestData)((Object)CLIENT_CACHE.get((Object)owner.toLowerCase(), (Object)code.toUpperCase())) : (ChestData)((Object)DATABASE.get((Object)owner.toLowerCase(), (Object)code.toUpperCase()));
        if (chestData == null) {
            chestData = new ChestData(owner, code);
            ChestHelper.putChestData(owner, code, chestData, isClient);
        }
        return chestData;
    }

    private static void putChestData(String owner, String code, ChestData data, boolean isClient) {
        if (isClient) {
            CLIENT_CACHE.put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)data);
        } else {
            DATABASE.put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)data);
        }
    }

    public static InventoryInternal getChest(Level world, String owner, String code) {
        return ChestHelper.getChestData(owner, code, world.f_46443_);
    }

    public static short getCapacity(Level world, String owner, String code) {
        return (short)ChestHelper.getChestData(owner, code, world.f_46443_).m_6643_();
    }

    public static void setCapacity(Level world, String owner, String code, byte capacity) {
        ChestHelper.getChestData(owner, code, world.f_46443_).setCapacity(capacity);
    }

    public void saveChestData(WorldEvent.Save event) {
        if (event.getWorld() == null || event.getWorld().m_5776_() || !needsSaving) {
            return;
        }
        if (!isLoaded) {
            EnderChests.LOGGER.error("Attempted to save EnderChest Data when nothing is loaded");
            return;
        }
        this.saveChestData();
    }

    private void saveChestData() {
        if (Strings.isNullOrEmpty((String)saveDir)) {
            saveDir = "sp_recovery" + File.separator + "enderchests" + File.separator + dateTime.format(LocalDateTime.now());
            EnderChests.LOGGER.error("World Save Directory Unknown, Saving to Recovery Folder: " + saveDir);
        }
        Set networks = DATABASE.rowKeySet();
        for (String owner : networks) {
            Map networkMap = DATABASE.row((Object)owner);
            CompoundTag fileNBT = new CompoundTag();
            for (Map.Entry pocket : networkMap.entrySet()) {
                if (!((ChestData)((Object)pocket.getValue())).saveCheck()) continue;
                CompoundTag nbtPocket = ((ChestData)((Object)pocket.getValue())).saveToNBT(new CompoundTag());
                fileNBT.m_128365_((String)pocket.getKey(), (Tag)nbtPocket);
            }
            NBTFile.write((CompoundTag)fileNBT, (File)this.getSaveFile(owner), (Logger)EnderChests.LOGGER);
        }
        needsSaving = false;
    }

    public void loadChestData() {
        Path folder_old;
        EnderChests.LOGGER.info("Loading EnderChest Data");
        LocationManager.clear();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Path folder = server.m_129843_(new LevelResource("data/enderchests"));
        if (!folder.toFile().exists() && (folder_old = server.m_129843_(new LevelResource("enderchests"))).toFile().exists()) {
            boolean moved = false;
            try {
                moved = folder_old.toFile().renameTo(folder.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (moved) {
                EnderChests.LOGGER.info("Moved 'enderchests' folder into 'data' folder");
            } else {
                folder = folder_old;
                EnderChests.LOGGER.error("Unable to automatically move 'enderchests' folder into 'data' folder. Old location will used. ");
            }
        }
        if (folder == null) {
            EnderChests.LOGGER.error("Failed to Load Chest Data, World Save Directory Unknown");
            return;
        }
        saveDir = folder.toString();
        List<File> fileList = this.getSaveFiles();
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", ""));
            CompoundTag fileNBT = NBTFile.read((File)file, (Logger)EnderChests.LOGGER);
            for (String code : fileNBT.m_128431_()) {
                ChestHelper.putChestData(owner, code, new ChestData(owner, code).loadFromNBT(fileNBT.m_128469_(code)), false);
            }
        }
        isLoaded = true;
        EnderChests.LOGGER.info("Finished Loading EnderChest Data");
    }

    public void unloadChestData() {
        boolean doMessage = false;
        if (isLoaded) {
            EnderChests.LOGGER.info("Unloading EnderChest Data");
            if (needsSaving) {
                this.saveChestData();
            }
            doMessage = true;
        }
        CLIENT_CACHE.clear();
        DATABASE.clear();
        isLoaded = false;
        saveDir = null;
        LocationManager.clear();
        if (doMessage) {
            EnderChests.LOGGER.info("Finished Unloading EnderChest Data");
        }
    }

    private List<File> getSaveFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(String owner) {
        File file = new File(saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(saveDir, this.getSaveID(owner) + ".dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                EnderChests.LOGGER.error("Could Not Read or Create File: " + file.toString(), (Throwable)error);
            }
        }
        return file;
    }

    private String getSaveID(String owner) {
        return owner.equalsIgnoreCase("all") ? "[-Public-]" : owner;
    }

    private String getOwnerID(String owner) {
        return owner.equalsIgnoreCase("[-Public-]") ? "all" : owner;
    }
}

