/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.client.render.RenderRegistry;

public class ItemEnderPouch
extends Item {
    private static final Component VANILLA_ENDER_CHEST_NAME = new TranslatableComponent("container.enderchest");

    public ItemEnderPouch(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)((Object)this), (Object)"open", (stack, world, entity, number) -> ItemEnderPouch.isOpen(stack) ? 1.0f : 0.0f)));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        if (this.m_41389_(group)) {
            list.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        ItemEnderPouch.setOpenState(stack, false);
    }

    public static boolean isOpen(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("open")) {
            return tag.m_128471_("open");
        }
        ItemEnderPouch.setOpenState(stack, false);
        return false;
    }

    private static void setOpenState(ItemStack stack, boolean isOpen) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("open", isOpen);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (((Boolean)Configuration.ACCESS_SETTINGS.allowEnderPouch.get()).booleanValue()) {
            if (!ItemEnderPouch.isOpen(stack)) {
                ItemEnderPouch.setOpenState(stack, true);
            }
            player.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            if (!world.f_46443_) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((id, invPlayer, entity) -> ChestMenu.m_39237_((int)id, (Inventory)invPlayer, (Container)invPlayer.f_35978_.m_36327_()), VANILLA_ENDER_CHEST_NAME));
                player.m_36220_(Stats.f_12963_);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemEnderPouch.isOpen(stack)) {
            AbstractContainerMenu container;
            if (isSelected && entity instanceof Player && (container = ((Player)entity).f_36096_) instanceof ChestMenu) {
                return;
            }
            ItemEnderPouch.setOpenState(stack, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        if (!((Boolean)Configuration.ACCESS_SETTINGS.allowEnderPouch.get()).booleanValue()) {
            tooltip.add((Component)new TextComponent("\u00a7o" + Localization.get((String)"info.enderchests.craftingmaterial")));
        }
    }
}

