/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty.entity;

import com.lupicus.nasty.config.MyConfig;
import com.lupicus.nasty.entity.IHasVirus;
import com.lupicus.nasty.entity.ModEntities;
import com.lupicus.nasty.entity.NastyWolfEntity;
import com.lupicus.nasty.entity.ai.controller.JumpMovementController;
import com.lupicus.nasty.entity.ai.goal.SpreadVirusGoal;
import com.lupicus.nasty.item.ModItems;
import com.lupicus.nasty.pathfinding.JumpPathNavigator;
import com.lupicus.nasty.util.ArrowHelper;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class NastySkeletonEntity
extends AbstractSkeleton
implements IHasVirus {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int NVARIANTS = 6;
    private static int defVariant = 0;
    private static boolean singleVariant = false;
    private static HashMap<String, AdjParms> biomeMap = new HashMap();
    private static final EntityDataAccessor<Integer> SUB_TYPE = SynchedEntityData.m_135353_(NastySkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final RangedBowAttackGoal<NastySkeletonEntity> bowGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 40.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

        public void m_8041_() {
            super.m_8041_();
            NastySkeletonEntity.this.m_21561_(false);
        }

        public void m_8056_() {
            super.m_8056_();
            NastySkeletonEntity.this.m_21561_(true);
        }
    };

    public NastySkeletonEntity(EntityType<? extends NastySkeletonEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_32164_();
        this.f_21342_ = new JumpMovementController((Mob)this);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7878_() {
        return SoundEvents.f_12383_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractSkeleton.m_32166_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8099_() {
        if (MyConfig.virusChance > 0.0f && MyConfig.virusDistance > 0.0f) {
            this.f_21345_.m_25352_(1, (Goal)new SpreadVirusGoal(this, Skeleton.class, MyConfig.virusDistance, MyConfig.virusChance));
        }
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUB_TYPE, (Object)0);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new JumpPathNavigator((Mob)this, worldIn);
    }

    public int getSubType() {
        return (Integer)this.f_19804_.m_135370_(SUB_TYPE);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("SubType", (byte)this.getSubType());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(SUB_TYPE, (Object)compound.m_128445_("SubType"));
    }

    public ResourceLocation m_7582_() {
        ResourceLocation res = super.m_7582_();
        return new ResourceLocation(res.m_135827_(), res.m_135815_() + "/" + this.getSubType());
    }

    public void m_32164_() {
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            if (this.meleeGoal == null) {
                return;
            }
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (itemstack.m_41720_() instanceof BowItem) {
                int i = 20;
                if (this.f_19853_.m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal.m_25797_(i);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        double temp;
        double dz;
        double dx;
        double d2;
        BlockPos pos = this.m_142538_();
        Biome biome = (Biome)worldIn.m_204166_(pos).m_203334_();
        if (MyConfig.spawnTempBased && (reason == MobSpawnType.NATURAL || reason == MobSpawnType.CHUNK_GENERATION)) {
            float temp2 = biome.m_47505_(pos);
            int subtype = singleVariant ? defVariant : this.randomTempBased(temp2);
            this.f_19804_.m_135381_(SUB_TYPE, (Object)subtype);
        } else if (reason != MobSpawnType.CONVERSION) {
            int subtype = singleVariant ? defVariant : this.randomVariant();
            this.f_19804_.m_135381_(SUB_TYPE, (Object)subtype);
        }
        if (difficultyIn.m_19048_() == Difficulty.HARD) {
            this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("difficulty", 3.0, AttributeModifier.Operation.ADDITION));
        }
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        LevelData winfo = worldIn.m_6106_();
        BlockPos spos = new BlockPos(winfo.m_6789_(), winfo.m_6527_(), winfo.m_6526_());
        double x0 = spos.m_123341_();
        double z0 = spos.m_123343_();
        double xzf = worldIn.m_6042_().m_63959_();
        if (xzf != 1.0) {
            x0 /= xzf;
            z0 /= xzf;
        }
        if ((d2 = (dx = (double)pos.m_123341_() - x0) * dx + (dz = (double)pos.m_123343_() - z0) * dz) >= MyConfig.maxDistanceSq) {
            temp = MyConfig.maxHealth;
        } else if (d2 <= MyConfig.minDistanceSq) {
            temp = MyConfig.minHealth;
        } else {
            double p = (Math.sqrt(d2) - MyConfig.minDistance) / (MyConfig.maxDistance - MyConfig.minDistance);
            temp = (MyConfig.maxHealth - MyConfig.minHealth) * p + MyConfig.minHealth;
        }
        float health = (float)Math.floor(temp);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)health);
        this.m_21153_(this.m_21233_());
        String keyPrefix = worldIn.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome) + ":";
        AdjParms adj = biomeMap.get(keyPrefix + this.getSubType());
        if (adj == null) {
            adj = biomeMap.get(keyPrefix + "*");
        }
        if (adj != null) {
            double val = adj.hp;
            if (val != 0.0) {
                this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("biome", val, AttributeModifier.Operation.MULTIPLY_BASE));
                this.m_21153_(this.m_21233_());
            }
            if ((val = adj.speed) != 0.0) {
                this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("biome", val, AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
        this.setPotionsBasedOnDifficulty(difficultyIn);
        return spawnDataIn;
    }

    public static void configUpdate() {
        NastySkeletonEntity.setupWeights();
        NastySkeletonEntity.setupBiomes();
    }

    private static void setupBiomes() {
        String[] array = MyConfig.biomeAdjustments;
        biomeMap.clear();
        for (int i = 0; i < array.length; ++i) {
            String line = array[i].trim();
            String[] fields = line.split(",");
            try {
                if (fields.length != 4) {
                    throw new Exception("bad number of fields");
                }
                String biomeName = fields[0].trim();
                String variant = fields[1].trim();
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
                if (biome == null) {
                    throw new Exception("bad biome value");
                }
                if (!variant.equals("*")) {
                    int j = Integer.parseInt(variant);
                    if (j < 0 || j >= 6) {
                        throw new Exception("bad variant value");
                    }
                    variant = Integer.toString(j);
                }
                biomeMap.put(biomeName + ":" + variant, new AdjParms(Double.parseDouble(fields[2]), Double.parseDouble(fields[3])));
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("Skipping bad Biome adjustment= " + line);
                LOGGER.warn("Reason= " + e.getMessage());
            }
        }
    }

    private static void setupWeights() {
        int[] array = MyConfig.spawnVariantWeights;
        int count = 0;
        boolean first = true;
        for (int i = 0; i < 6; ++i) {
            if (array[i] <= 0) continue;
            ++count;
            if (!first) continue;
            first = false;
            defVariant = i;
        }
        if (count <= 1) {
            singleVariant = true;
        }
    }

    private int randomVariant() {
        return this.randomWeight(MyConfig.spawnVariantWeights);
    }

    private int randomTempBased(float temp) {
        int[] standard = MyConfig.spawnVariantWeights;
        int[] choices = new int[6];
        for (int i = 0; i < 6; ++i) {
            choices[i] = standard[i];
        }
        if (!(temp > 0.2f) || !(temp < 1.2f)) {
            choices[0] = 0;
        }
        if (!(temp > 1.0f)) {
            choices[1] = 0;
        }
        if (!(temp < 0.4f)) {
            choices[2] = 0;
        }
        return this.randomWeight(choices);
    }

    private int randomWeight(int[] weights) {
        int sum = 0;
        for (int i = 0; i < 6; ++i) {
            sum += weights[i];
        }
        if (sum > 0) {
            int j = this.f_19796_.nextInt(sum);
            for (int i = 0; i < 6; ++i) {
                if (j < weights[i]) {
                    return i;
                }
                j -= weights[i];
            }
        }
        return defVariant;
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.m_45517_(LightLayer.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        if (worldIn.m_45517_(LightLayer.BLOCK, pos) > MyConfig.spawnBlockLight) {
            return false;
        }
        int i = worldIn.m_6018_().m_46470_() ? worldIn.m_46849_(pos, 10) : worldIn.m_46803_(pos);
        return i <= randomIn.nextInt(MyConfig.spawnLightLevel + 1);
    }

    public static boolean checkSpawnRules(EntityType<? extends NastySkeletonEntity> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && NastySkeletonEntity.isDarkEnoughToSpawn(worldIn, pos, randomIn) && NastySkeletonEntity.m_21400_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected void setPotionsBasedOnDifficulty(DifficultyInstance difficulty) {
        int amp = 2;
        if (difficulty.m_19048_() == Difficulty.HARD) {
            ++amp;
        }
        this.m_7292_(new MobEffectInstance(MobEffects.f_19603_, Integer.MAX_VALUE, amp));
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        super.m_6851_(difficulty);
        ItemStack stack = this.m_6844_(EquipmentSlot.HEAD);
        if (stack.m_41619_() || stack.m_41720_() == Items.f_42407_) {
            stack = new ItemStack((ItemLike)Items.f_42407_);
            CompoundTag nbt = stack.m_41698_("display");
            int subtype = this.getSubType();
            int color = subtype == 0 ? 65280 : (subtype == 1 ? 0xFF0000 : (subtype == 2 ? 0xFF00FF : (subtype == 3 ? 33023 : (subtype == 4 ? 16738816 : 16766976))));
            nbt.m_128405_("color", color);
            this.m_8061_(EquipmentSlot.HEAD, stack);
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack bow = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
        ItemStack itemstack = this.m_6298_(bow);
        AbstractArrow abstractarrowentity = this.m_7932_(itemstack, distanceFactor);
        Item item2 = bow.m_41720_();
        if (item2 instanceof BowItem) {
            BowItem bowItem = (BowItem)item2;
            abstractarrowentity = bowItem.customArrow(abstractarrowentity);
        }
        this.enchantArrow(abstractarrowentity);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        if (d3 > 40.0) {
            return;
        }
        double velocity = 1.6;
        d1 = ArrowHelper.computeY(d3, d1, velocity, abstractarrowentity.m_20186_(), target.m_20186_(), target.m_20206_());
        float inaccuracy = 0.0f;
        if (this.f_19796_.nextDouble() < MyConfig.addInaccuracy) {
            inaccuracy = 14 - this.f_19853_.m_46791_().m_19028_() * 4;
        }
        abstractarrowentity.m_6686_(d0, d1, d2, (float)velocity, inaccuracy);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item instanceof BowItem;
    }

    public ItemStack m_6298_(ItemStack shootable) {
        int subtype = this.getSubType();
        if (subtype == 2) {
            return new ItemStack((ItemLike)ModItems.MAGIC_ARROW);
        }
        if (subtype == 4) {
            return new ItemStack((ItemLike)ModItems.EXPLOSIVE_ARROW);
        }
        return super.m_6298_(shootable);
    }

    protected void enchantArrow(AbstractArrow entity) {
        int subtype;
        int i;
        int j = 1;
        if (this.f_19853_.m_46791_() == Difficulty.HARD) {
            ++j;
            i = MyConfig.bonusHardPower;
        } else {
            i = MyConfig.bonusPower;
        }
        if (i > 0) {
            entity.m_36781_(entity.m_36789_() + (double)(i + 1) * 0.5);
        }
        if (j > 0) {
            entity.m_36735_(j);
        }
        if ((subtype = this.getSubType()) == 0) {
            ((Arrow)entity).m_36870_(new MobEffectInstance(MobEffects.f_19614_, MyConfig.poisonTime));
        } else if (subtype == 1) {
            entity.m_7311_(100);
        } else if (subtype == 3) {
            ((Arrow)entity).m_36870_(new MobEffectInstance(MobEffects.f_19620_, 140));
        } else if (subtype == 5) {
            MobEffect effect = MyConfig.useBlindness ? MobEffects.f_19610_ : MobEffects.f_19604_;
            ((Arrow)entity).m_36870_(new MobEffectInstance(effect, MyConfig.yellowTime, 1));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Wolf mob;
        Entity entity = source.m_7639_();
        if (amount > 0.0f && entity != null && entity instanceof ServerPlayer) {
            Player player = (Player)entity;
            double new_range = 64.0;
            AttributeInstance attr = this.m_21051_(Attributes.f_22277_);
            if (new_range > attr.m_22115_()) {
                attr.m_22100_(new_range);
            }
            this.m_6703_((LivingEntity)player);
        }
        boolean flag = super.m_6469_(source, amount);
        entity = source.m_7640_();
        if (flag && entity instanceof Wolf && NastyWolfEntity.canInfect(mob = (Wolf)entity)) {
            NastyWolfEntity.onInfect(mob);
        }
        return flag;
    }

    protected void m_6475_(DamageSource source, float damageAmount) {
        if (source.m_19360_()) {
            damageAmount = (float)((double)damageAmount * MyConfig.arrowDamageMultiplier);
        }
        super.m_6475_(source, damageAmount);
    }

    @Override
    public void onInfect(Entity mob) {
        Entity riding;
        ServerLevel world = (ServerLevel)mob.f_19853_;
        Vec3 mobpos = mob.m_20182_();
        if (mob.m_20096_()) {
            mob.m_20334_(0.0, 0.0, 0.0);
        }
        NastySkeletonEntity newmob = (NastySkeletonEntity)ModEntities.NASTY_SKELETON.m_20615_((Level)world);
        if (mob.m_8077_()) {
            newmob.m_6593_(mob.m_7770_());
            newmob.m_20340_(mob.m_20151_());
        }
        newmob.m_6842_(mob.m_20145_());
        newmob.m_20331_(mob.m_20147_());
        newmob.m_7678_(mobpos.m_7096_(), mobpos.m_7098_(), mobpos.m_7094_(), mob.m_146908_(), mob.m_146909_());
        newmob.f_19804_.m_135381_(SUB_TYPE, (Object)this.getSubType());
        newmob.m_6518_((ServerLevelAccessor)world, world.m_6436_(new BlockPos(mobpos)), MobSpawnType.CONVERSION, null, null);
        if (mob instanceof Mob) {
            Mob from = (Mob)mob;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = from.m_6844_(slot);
                newmob.m_8061_(slot, stack.m_41777_());
                newmob.m_21409_(slot, this.m_21519_(slot));
                stack.m_41764_(0);
            }
            newmob.m_21553_(from.m_21531_());
            if (from.m_21532_()) {
                newmob.m_21530_();
            }
            newmob.m_21557_(from.m_21525_());
            newmob.m_6703_(from.m_142581_());
            newmob.f_20885_ = from.f_20885_;
            newmob.f_20883_ = from.f_20885_;
        }
        if ((riding = mob.m_20202_()) != null) {
            mob.m_8127_();
            newmob.m_7998_(riding, true);
        } else {
            newmob.m_20256_(mob.m_20184_());
        }
        world.m_5898_((Player)null, 1027, newmob.m_142538_(), 0);
        world.m_7967_((Entity)newmob);
        mob.m_146870_();
    }

    private static class AdjParms {
        public double hp;
        public double speed;

        public AdjParms(double hp, double speed) {
            this.hp = hp;
            this.speed = speed;
        }
    }
}

