/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.io.sentry.transport;

import java.io.IOException;
import net.creeperhost.resourcefulcreepers.io.sentry.ISerializer;
import net.creeperhost.resourcefulcreepers.io.sentry.SentryEnvelope;
import net.creeperhost.resourcefulcreepers.io.sentry.transport.ITransport;
import net.creeperhost.resourcefulcreepers.io.sentry.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StdoutTransport
implements ITransport {
    @NotNull
    private final ISerializer serializer;

    public StdoutTransport(@NotNull ISerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer, "Serializer is required");
    }

    @Override
    public void send(@NotNull SentryEnvelope envelope, @Nullable Object hint) throws IOException {
        Objects.requireNonNull(envelope, "SentryEnvelope is required");
        try {
            this.serializer.serialize(envelope, System.out);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void flush(long timeoutMillis) {
        System.out.println("Flushing");
    }

    @Override
    public void close() {
    }
}

