/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.io.sentry.protocol;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.resourcefulcreepers.io.sentry.SentryBaseEvent;
import net.creeperhost.resourcefulcreepers.io.sentry.SentryTracer;
import net.creeperhost.resourcefulcreepers.io.sentry.Span;
import net.creeperhost.resourcefulcreepers.io.sentry.SpanContext;
import net.creeperhost.resourcefulcreepers.io.sentry.SpanStatus;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.Contexts;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.MeasurementValue;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.SentrySpan;
import net.creeperhost.resourcefulcreepers.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryTransaction
extends SentryBaseEvent {
    @Nullable
    private String transaction;
    @NotNull
    private final Date startTimestamp;
    @Nullable
    private Date timestamp;
    @NotNull
    private final List<SentrySpan> spans = new ArrayList<SentrySpan>();
    @NotNull
    private final String type = "transaction";
    @NotNull
    private final @NotNull Map<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();

    public SentryTransaction(@NotNull SentryTracer sentryTracer) {
        super(sentryTracer.getEventId());
        Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.startTimestamp = sentryTracer.getStartTimestamp();
        this.timestamp = sentryTracer.getTimestamp();
        this.transaction = sentryTracer.getName();
        for (Span span : sentryTracer.getChildren()) {
            if (!Boolean.TRUE.equals(span.isSampled())) continue;
            this.spans.add(new SentrySpan(span));
        }
        Contexts contexts = this.getContexts();
        for (Map.Entry entry : sentryTracer.getContexts().entrySet()) {
            contexts.put((String)entry.getKey(), entry.getValue());
        }
        this.setRequest(sentryTracer.getRequest());
        SpanContext spanContext = sentryTracer.getSpanContext();
        contexts.setTrace(new SpanContext(spanContext.getTraceId(), spanContext.getSpanId(), spanContext.getParentSpanId(), spanContext.getOperation(), spanContext.getDescription(), spanContext.getSampled(), spanContext.getStatus()));
        for (Map.Entry<String, String> entry : spanContext.getTags().entrySet()) {
            this.setTag(entry.getKey(), entry.getValue());
        }
        Map<String, Object> map = sentryTracer.getData();
        if (map != null) {
            for (Map.Entry<String, Object> tag : map.entrySet()) {
                this.setExtra(tag.getKey(), tag.getValue());
            }
        }
    }

    @NotNull
    public List<SentrySpan> getSpans() {
        return this.spans;
    }

    public boolean isFinished() {
        return this.timestamp != null;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Date getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String getType() {
        return "transaction";
    }

    @Nullable
    public SpanStatus getStatus() {
        SpanContext trace = this.getContexts().getTrace();
        return trace != null ? trace.getStatus() : null;
    }

    public boolean isSampled() {
        SpanContext trace = this.getContexts().getTrace();
        return trace != null && Boolean.TRUE.equals(trace.getSampled());
    }

    @NotNull
    public @NotNull Map<String, @NotNull MeasurementValue> getMeasurements() {
        return this.measurements;
    }
}

