/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.io.sentry;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import net.creeperhost.resourcefulcreepers.io.sentry.SentryEnvelopeHeader;
import net.creeperhost.resourcefulcreepers.io.sentry.TraceState;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.SdkVersion;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.SentryId;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.SentryPackage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryEnvelopeHeaderAdapter
extends TypeAdapter<SentryEnvelopeHeader> {
    public void write(@NotNull JsonWriter writer, @Nullable SentryEnvelopeHeader value) throws IOException {
        TraceState trace;
        SdkVersion sdkVersion;
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        if (value.getEventId() != null) {
            writer.name("event_id");
            writer.value(value.getEventId().toString());
        }
        if ((sdkVersion = value.getSdkVersion()) != null && this.hasValidSdkVersion(sdkVersion)) {
            List<SentryPackage> packages;
            writer.name("sdk").beginObject();
            writer.name("name").value(sdkVersion.getName());
            writer.name("version").value(sdkVersion.getVersion());
            List<String> integrations = sdkVersion.getIntegrations();
            if (integrations != null) {
                writer.name("integrations").beginArray();
                for (String integration : integrations) {
                    writer.value(integration);
                }
                writer.endArray();
            }
            if ((packages = sdkVersion.getPackages()) != null) {
                writer.name("packages").beginArray();
                for (SentryPackage item : packages) {
                    writer.beginObject();
                    writer.name("name").value(item.getName());
                    writer.name("version").value(item.getVersion());
                    writer.endObject();
                }
                writer.endArray();
            }
            writer.endObject();
        }
        if ((trace = value.getTrace()) != null) {
            writer.name("trace");
            writer.beginObject();
            writer.name("trace_id").value(trace.getTraceId().toString());
            writer.name("public_key").value(trace.getPublicKey());
            if (trace.getRelease() != null) {
                writer.name("release").value(trace.getRelease());
            }
            if (trace.getEnvironment() != null) {
                writer.name("environment").value(trace.getEnvironment());
            }
            if (trace.getTransaction() != null) {
                writer.name("transaction").value(trace.getTransaction());
            }
            if (trace.getUser() != null && (trace.getUser().getId() != null || trace.getUser().getSegment() != null)) {
                writer.name("user");
                writer.beginObject();
                if (trace.getUser().getId() != null) {
                    writer.name("id").value(trace.getUser().getId());
                }
                if (trace.getUser().getSegment() != null) {
                    writer.name("segment").value(trace.getUser().getSegment());
                }
                writer.endObject();
            }
            writer.endObject();
        }
        writer.endObject();
    }

    private boolean hasValidSdkVersion(@NotNull SdkVersion sdkVersion) {
        return sdkVersion.getName() != null && !sdkVersion.getName().isEmpty() && sdkVersion.getVersion() != null && !sdkVersion.getVersion().isEmpty();
    }

    @Nullable
    public SentryEnvelopeHeader read(@NotNull JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        SentryId eventId = null;
        SdkVersion sdkVersion = null;
        TraceState traceState = null;
        reader.beginObject();
        block54: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "event_id": {
                    eventId = new SentryId(reader.nextString());
                    continue block54;
                }
                case "sdk": {
                    reader.beginObject();
                    sdkVersion = new SdkVersion();
                    block55: while (reader.hasNext()) {
                        switch (reader.nextName()) {
                            case "name": {
                                sdkVersion.setName(reader.nextString());
                                continue block55;
                            }
                            case "version": {
                                sdkVersion.setVersion(reader.nextString());
                                continue block55;
                            }
                            case "integrations": {
                                reader.beginArray();
                                while (reader.hasNext()) {
                                    String integration = reader.nextString();
                                    if (integration == null) continue;
                                    sdkVersion.addIntegration(integration);
                                }
                                reader.endArray();
                                continue block55;
                            }
                            case "packages": {
                                reader.beginArray();
                                while (reader.hasNext()) {
                                    reader.beginObject();
                                    String name = null;
                                    String version = null;
                                    block58: while (reader.hasNext()) {
                                        switch (reader.nextName()) {
                                            case "name": {
                                                name = reader.nextString();
                                                continue block58;
                                            }
                                            case "version": {
                                                version = reader.nextString();
                                                continue block58;
                                            }
                                        }
                                        reader.skipValue();
                                    }
                                    if (name != null && version != null) {
                                        sdkVersion.addPackage(name, version);
                                    }
                                    reader.endObject();
                                }
                                reader.endArray();
                                continue block55;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block54;
                }
                case "trace": {
                    reader.beginObject();
                    SentryId traceId = null;
                    String publicKey = null;
                    String release = null;
                    String environment = null;
                    String transaction = null;
                    String userId = null;
                    String segment = null;
                    block59: while (reader.hasNext()) {
                        switch (reader.nextName()) {
                            case "trace_id": {
                                traceId = new SentryId(reader.nextString());
                                continue block59;
                            }
                            case "public_key": {
                                publicKey = reader.nextString();
                                continue block59;
                            }
                            case "release": {
                                release = reader.nextString();
                                continue block59;
                            }
                            case "environment": {
                                environment = reader.nextString();
                                continue block59;
                            }
                            case "transaction": {
                                transaction = reader.nextString();
                                continue block59;
                            }
                            case "user": {
                                reader.beginObject();
                                block60: while (reader.hasNext()) {
                                    switch (reader.nextName()) {
                                        case "id": {
                                            userId = reader.nextString();
                                            continue block60;
                                        }
                                        case "segment": {
                                            segment = reader.nextString();
                                            continue block60;
                                        }
                                    }
                                    reader.skipValue();
                                }
                                reader.endObject();
                                continue block59;
                            }
                        }
                        reader.skipValue();
                    }
                    if (traceId != null && publicKey != null) {
                        traceState = new TraceState(traceId, publicKey, release, environment, userId != null || segment != null ? new TraceState.TraceStateUser(userId, segment) : null, transaction);
                    }
                    reader.endObject();
                    continue block54;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return new SentryEnvelopeHeader(eventId, sdkVersion, traceState);
    }
}

