/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.io.sentry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.resourcefulcreepers.io.sentry.Breadcrumb;
import net.creeperhost.resourcefulcreepers.io.sentry.exception.ExceptionMechanismException;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.Contexts;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.Request;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.SdkVersion;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.SentryId;
import net.creeperhost.resourcefulcreepers.io.sentry.protocol.User;
import net.creeperhost.resourcefulcreepers.io.sentry.util.CollectionUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SentryBaseEvent {
    public static final String DEFAULT_PLATFORM = "java";
    @Nullable
    private SentryId eventId;
    @NotNull
    private final Contexts contexts = new Contexts();
    @Nullable
    private SdkVersion sdk;
    @Nullable
    private Request request;
    @Nullable
    private Map<String, String> tags;
    @Nullable
    private String release;
    @Nullable
    private String environment;
    @Nullable
    private String platform;
    @Nullable
    private User user;
    @Nullable
    protected transient Throwable throwable;
    @Nullable
    private String serverName;
    @Nullable
    private String dist;
    @Nullable
    private List<Breadcrumb> breadcrumbs;
    @Nullable
    private Map<String, Object> extra;

    protected SentryBaseEvent(@NotNull SentryId eventId) {
        this.eventId = eventId;
    }

    protected SentryBaseEvent() {
        this(new SentryId());
    }

    @Nullable
    public SentryId getEventId() {
        return this.eventId;
    }

    public void setEventId(@Nullable SentryId eventId) {
        this.eventId = eventId;
    }

    @NotNull
    public Contexts getContexts() {
        return this.contexts;
    }

    @Nullable
    public SdkVersion getSdk() {
        return this.sdk;
    }

    public void setSdk(@Nullable SdkVersion sdk) {
        this.sdk = sdk;
    }

    @Nullable
    public Request getRequest() {
        return this.request;
    }

    public void setRequest(@Nullable Request request) {
        this.request = request;
    }

    @Nullable
    public Throwable getThrowable() {
        Throwable ex = this.throwable;
        if (ex instanceof ExceptionMechanismException) {
            return ((ExceptionMechanismException)ex).getThrowable();
        }
        return ex;
    }

    @Deprecated
    @Nullable
    public Throwable getOriginThrowable() {
        return this.getThrowable();
    }

    @Nullable
    Throwable getThrowableMechanism() {
        return this.throwable;
    }

    public void setThrowable(@Nullable Throwable throwable) {
        this.throwable = throwable;
    }

    @ApiStatus.Internal
    @Nullable
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(@Nullable Map<String, String> tags) {
        this.tags = CollectionUtils.newHashMap(tags);
    }

    public void removeTag(@NotNull String key) {
        if (this.tags != null) {
            this.tags.remove(key);
        }
    }

    @Nullable
    public String getTag(@NotNull String key) {
        if (this.tags != null) {
            return this.tags.get(key);
        }
        return null;
    }

    public void setTag(@NotNull String key, @NotNull String value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, value);
    }

    @Nullable
    public String getRelease() {
        return this.release;
    }

    public void setRelease(@Nullable String release) {
        this.release = release;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@Nullable String environment) {
        this.environment = environment;
    }

    @Nullable
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(@Nullable String platform) {
        this.platform = platform;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(@Nullable String serverName) {
        this.serverName = serverName;
    }

    @Nullable
    public String getDist() {
        return this.dist;
    }

    public void setDist(@Nullable String dist) {
        this.dist = dist;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    public void setUser(@Nullable User user) {
        this.user = user;
    }

    @Nullable
    public List<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public void setBreadcrumbs(@Nullable List<Breadcrumb> breadcrumbs) {
        this.breadcrumbs = CollectionUtils.newArrayList(breadcrumbs);
    }

    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        if (this.breadcrumbs == null) {
            this.breadcrumbs = new ArrayList<Breadcrumb>();
        }
        this.breadcrumbs.add(breadcrumb);
    }

    @Nullable
    Map<String, Object> getExtras() {
        return this.extra;
    }

    public void setExtras(@Nullable Map<String, Object> extra) {
        this.extra = CollectionUtils.newHashMap(extra);
    }

    public void setExtra(@NotNull String key, @NotNull Object value) {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>();
        }
        this.extra.put(key, value);
    }

    public void removeExtra(@NotNull String key) {
        if (this.extra != null) {
            this.extra.remove(key);
        }
    }

    @Nullable
    public Object getExtra(@NotNull String key) {
        if (this.extra != null) {
            return this.extra.get(key);
        }
        return null;
    }

    public void addBreadcrumb(@Nullable String message) {
        this.addBreadcrumb(new Breadcrumb(message));
    }
}

