/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.io.sentry;

import net.creeperhost.resourcefulcreepers.io.sentry.EnvelopeSender;
import net.creeperhost.resourcefulcreepers.io.sentry.IHub;
import net.creeperhost.resourcefulcreepers.io.sentry.SendCachedEnvelopeFireAndForgetIntegration;
import net.creeperhost.resourcefulcreepers.io.sentry.SentryLevel;
import net.creeperhost.resourcefulcreepers.io.sentry.SentryOptions;
import net.creeperhost.resourcefulcreepers.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SendFireAndForgetEnvelopeSender
implements SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory {
    @NotNull
    private final SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetDirPath sendFireAndForgetDirPath;

    public SendFireAndForgetEnvelopeSender(@NotNull SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetDirPath sendFireAndForgetDirPath) {
        this.sendFireAndForgetDirPath = Objects.requireNonNull(sendFireAndForgetDirPath, "SendFireAndForgetDirPath is required");
    }

    @Override
    @Nullable
    public SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForget create(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull(hub, "Hub is required");
        Objects.requireNonNull(options, "SentryOptions is required");
        String dirPath = this.sendFireAndForgetDirPath.getDirPath();
        if (dirPath == null || !this.hasValidPath(dirPath, options.getLogger())) {
            options.getLogger().log(SentryLevel.ERROR, "No cache dir path is defined in options.", new Object[0]);
            return null;
        }
        EnvelopeSender envelopeSender = new EnvelopeSender(hub, options.getSerializer(), options.getLogger(), options.getFlushTimeoutMillis());
        return this.processDir(envelopeSender, dirPath, options.getLogger());
    }
}

