/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.init;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.utils.Env;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.creeperhost.resourcefulcreepers.Constants;
import net.creeperhost.resourcefulcreepers.ResourcefulCreepersExpectPlatform;
import net.creeperhost.resourcefulcreepers.client.ResourcefulCreeperRender;
import net.creeperhost.resourcefulcreepers.data.CreeperType;
import net.creeperhost.resourcefulcreepers.data.CreeperTypeList;
import net.creeperhost.resourcefulcreepers.entites.EntityResourcefulCreeper;
import net.creeperhost.resourcefulcreepers.io.sentry.Sentry;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((String)"resourcefulcreepers", (ResourceKey)Registry.f_122903_);
    public static final DeferredRegister<Item> SPAWN_EGG_ITEMS = DeferredRegister.create((String)"resourcefulcreepers", (ResourceKey)Registry.f_122904_);
    public static final CreativeModeTab CREATIVE_TAB = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation("resourcefulcreepers", "creative_tab"), () -> new ItemStack((ItemLike)Items.f_42682_));
    public static final HashMap<EntityType<EntityResourcefulCreeper>, Integer> STORED_TYPES = new HashMap();
    public static final HashMap<String, String> MOB_NAMES = new HashMap();

    public static void init() {
        ModEntities.loadCreeperTypes();
    }

    public static void loadCreeperTypes() {
        if (CreeperTypeList.INSTANCE.creeperTypes.isEmpty()) {
            return;
        }
        for (final CreeperType creeperType : CreeperTypeList.INSTANCE.creeperTypes) {
            try {
                try {
                    EntityType entityType = EntityType.Builder.m_20704_(EntityResourcefulCreeper::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.7f).m_20702_(8).m_20712_(creeperType.getName());
                    ENTITIES.register(creeperType.getName(), () -> entityType);
                    STORED_TYPES.put((EntityType<EntityResourcefulCreeper>)entityType, creeperType.getSpawnWeight());
                    EntityAttributeRegistry.register(() -> entityType, () -> EntityResourcefulCreeper.prepareAttributes(creeperType));
                    if (Platform.getEnvironment() == Env.CLIENT) {
                        MOB_NAMES.put("entity.resourcefulcreepers." + creeperType.getName(), creeperType.getDisplayName());
                        EntityRendererRegistry.register(() -> entityType, ResourcefulCreeperRender::new);
                    }
                    SpawnEggItem spawnEggItem = new SpawnEggItem(entityType, creeperType.getSpawnEggColour1(), creeperType.getSpawnEggColour2(), new Item.Properties().m_41491_(CREATIVE_TAB)){

                        public Component m_7626_(ItemStack itemStack) {
                            return new TranslatableComponent(creeperType.getDisplayName() + " Spawn Egg");
                        }

                        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
                            list.add((Component)new TranslatableComponent("Tier: " + creeperType.getTier()));
                            list.add((Component)new TranslatableComponent("Block: " + creeperType.getItemDrops().get(0).getName()));
                            super.m_7373_(itemStack, level, list, tooltipFlag);
                        }
                    };
                    SPAWN_EGG_ITEMS.register(creeperType.getName(), () -> spawnEggItem);
                }
                catch (Exception e) {
                    Sentry.captureException(e);
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                Sentry.captureException(e);
                e.printStackTrace();
            }
        }
        if (Platform.getEnvironment() == Env.CLIENT) {
            ModEntities.createResourcePack();
        }
        ENTITIES.register();
        SPAWN_EGG_ITEMS.register();
        STORED_TYPES.forEach(ResourcefulCreepersExpectPlatform::registerSpawns);
    }

    public static void createResourcePack() {
        try {
            System.out.println("Creating resource pack");
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            String jsonString = gson.toJson(MOB_NAMES);
            File folders = Constants.CONFIG_FOLDER.resolve("ResourcefulCreepers/assets/minecraft/lang").toFile();
            if (!folders.exists()) {
                folders.mkdirs();
            }
            File file = folders.toPath().resolve("en_us.json").toFile();
            ModEntities.createMeta(Constants.CONFIG_FOLDER.resolve("ResourcefulCreepers/pack.mcmeta").toFile());
            if (!file.exists()) {
                try (FileOutputStream configOut2 = new FileOutputStream(file);){
                    IOUtils.write((String)jsonString, (OutputStream)configOut2, (Charset)Charset.defaultCharset());
                }
                catch (Throwable configOut2) {
                    // empty catch block
                }
            }
            try {
                ModEntities.pack(Constants.CONFIG_FOLDER.resolve("ResourcefulCreepers").toString(), Platform.getGameFolder().resolve("resourcepacks/ResourcefulCreepers.zip").toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createMeta(File file) {
        if (!file.exists()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            Meta meta = new Meta();
            String json = gson.toJson((Object)meta);
            try (FileOutputStream configOut = new FileOutputStream(file);){
                IOUtils.write((String)json, (OutputStream)configOut, (Charset)Charset.defaultCharset());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void pack(String sourceDirPath, String zipFilePath) throws IOException {
        if (Paths.get(zipFilePath, new String[0]).toFile().exists()) {
            return;
        }
        Path p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        Path pp = Paths.get(sourceDirPath, new String[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));
             Stream<Path> paths = Files.walk(pp, new FileVisitOption[0]);){
            paths.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static class Meta {
        Pack pack = new Pack();
    }

    public static class Pack {
        String description = "resourcefulcreepers";
        int pack_format = 8;
    }
}

