/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.forge;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.creeperhost.resourcefulcreepers.entites.EntityResourcefulCreeper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.fml.loading.FMLPaths;

public class ResourcefulCreepersExpectPlatformImpl {
    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static void registerSpawns(EntityType<EntityResourcefulCreeper> entityType, int weight) {
        SpawnPlacements.m_21754_(entityType, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, ResourcefulCreepersExpectPlatformImpl::genericGroundSpawn);
    }

    public static boolean genericGroundSpawn(EntityType<? extends Entity> entityType, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random random) {
        if (!worldIn.m_6042_().m_63956_()) {
            return false;
        }
        if (worldIn.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        return worldIn.m_46803_(pos) <= 4;
    }

    public static List<Block> getDefaults() {
        TagKey tag = Tags.Blocks.ORES;
        Iterable i = Registry.f_122824_.m_206058_(tag);
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (Holder blockHolder : i) {
            blockList.add((Block)blockHolder.m_203334_());
        }
        System.out.println(blockList);
        return blockList;
    }

    public static int getColour(ItemStack itemStack) {
        if (Minecraft.m_91087_().getItemColors() != null) {
            return Minecraft.m_91087_().getItemColors().m_92676_(itemStack, 0);
        }
        return 0;
    }

    public static List<Tier> getTierList() {
        return TierSortingRegistry.getSortedTiers();
    }

    public static boolean isCorrectTierForDrops(Tier tier, BlockState blockState) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)blockState);
    }
}

