/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.entites;

import java.util.ArrayList;
import java.util.List;
import net.creeperhost.resourcefulcreepers.ResourcefulCreepers;
import net.creeperhost.resourcefulcreepers.config.Config;
import net.creeperhost.resourcefulcreepers.data.CreeperType;
import net.creeperhost.resourcefulcreepers.entites.goals.RcSwellGoal;
import net.creeperhost.resourcefulcreepers.init.ModEntities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class EntityResourcefulCreeper
extends Animal
implements PowerableMob {
    private CreeperType creeperType;
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(EntityResourcefulCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(EntityResourcefulCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(EntityResourcefulCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_TAMED = SynchedEntityData.m_135353_(EntityResourcefulCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    private final EntityType<?> entityType;

    public EntityResourcefulCreeper(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        String name;
        CreeperType creeperType;
        this.entityType = entityType;
        String[] split = entityType.m_20675_().split("\\.");
        if (split.length > 2 && (creeperType = ResourcefulCreepers.getTypeFromName(name = split[2])) != null) {
            this.creeperType = creeperType;
        }
    }

    public Component m_7755_() {
        if (this.f_19853_.f_46443_ && this.creeperType != null) {
            if (this.m_8077_()) {
                return this.m_7770_();
            }
            return new TranslatableComponent(this.creeperType.getDisplayName());
        }
        if (super.m_7755_() == null) {
            return new TextComponent("null");
        }
        return super.m_7755_();
    }

    public CreeperType getCreeperType() {
        return this.creeperType;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RcSwellGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        if (Config.INSTANCE.creepersAttractedToArmourStand) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ArmorStand.class, true));
        }
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder prepareAttributes(CreeperType creeperType) {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 0.1).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.25).m_22268_(Attributes.f_22284_, creeperType.getArmourValue()).m_22266_(Attributes.f_22282_).m_22268_(Attributes.f_22277_, 15.0);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            if (Config.INSTANCE.nonHostileWhenTamed && this.isTamed() && this.m_5448_() != null && this.m_5448_() instanceof Player) {
                this.m_6710_(null);
            }
            if (!this.shouldExplode()) {
                this.setSwellDir(-1);
            }
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell > this.maxSwell || this.f_19853_.f_46443_ && this.swell >= this.maxSwell - 1) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    public boolean shouldExplode() {
        return !Config.INSTANCE.nonHostileWhenTamed || !this.isTamed();
    }

    private void explodeCreeper() {
        if (Config.INSTANCE.explosionsGenerateOres) {
            float f = this.m_7090_() ? Config.INSTANCE.poweredExplosionMultiplier : Config.INSTANCE.explosionMultiplier;
            this.f_20890_ = true;
            if (this.m_6162_()) {
                f /= 2.0f;
            }
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7785_(x, y, z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_19853_.f_46441_.nextFloat() - this.f_19853_.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
            }
            Explosion explosion = new Explosion(this.f_19853_, (Entity)this, x, y, z, (float)this.explosionRadius * f);
            explosion.m_46061_();
            Block block = Blocks.f_50016_;
            for (ItemStack itemStack : this.getCreeperType().getItemDropsAsList()) {
                Item item;
                if (itemStack == null || itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.m_40614_();
                break;
            }
            if (!this.f_19853_.f_46443_) {
                for (BlockPos blockPos : explosion.m_46081_()) {
                    if (!this.f_19853_.m_8055_(blockPos).m_60795_() && !this.f_19853_.m_8055_(blockPos).m_204336_(BlockTags.f_198158_) && !this.f_19853_.m_8055_(blockPos).m_204336_(BlockTags.f_144279_)) continue;
                    this.f_19853_.m_7731_(blockPos, block.m_49966_(), 3);
                }
            }
            this.m_146870_();
        } else {
            Explosion.BlockInteraction blockInteraction = this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float f = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, blockInteraction);
            this.m_146870_();
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public void setPowered() {
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int i) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)i);
    }

    public float getSwelling(float f) {
        return Mth.m_14179_((float)f, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_TAMED);
    }

    public void setTamed() {
        this.f_19804_.m_135381_(DATA_IS_TAMED, (Object)true);
    }

    public void removedTamed() {
        this.f_19804_.m_135381_(DATA_IS_TAMED, (Object)false);
    }

    public void m_7472_(DamageSource damageSource, int i, boolean bl) {
        super.m_7472_(damageSource, i, bl);
        if (this.getCreeperType().shouldDropItemsOnDeath() && !Config.INSTANCE.overrideOreDrops) {
            for (ItemStack itemStack : this.getCreeperType().getItemDropsAsList()) {
                if (itemStack == null || itemStack.m_41619_()) continue;
                this.m_19983_(itemStack);
            }
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.m_7639_() != null && damageSource.m_7639_() instanceof Player) {
            this.removedTamed();
        }
        return super.m_6469_(damageSource, f);
    }

    public ResourceLocation m_7582_() {
        ResourceLocation resourcelocation = new ResourceLocation("minecraft:creeper");
        return new ResourceLocation(resourcelocation.m_135827_(), "entities/" + resourcelocation.m_135815_());
    }

    public boolean m_6898_(ItemStack itemStack) {
        boolean is = itemStack.m_150930_(Items.f_42403_);
        if (is) {
            this.setTamed();
        }
        return is;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        List<EntityType<?>> possible;
        boolean mutation;
        int currentTier = this.getCreeperType().getTier();
        int nextTier = currentTier + 1;
        AgeableMob baby = (AgeableMob)this.entityType.m_20615_((Level)serverLevel);
        boolean bl = mutation = serverLevel.f_46441_.nextInt(100) < 10;
        if (mutation && !(possible = this.getFromTier(nextTier, this.f_19853_)).isEmpty()) {
            int random = serverLevel.f_46441_.nextInt(possible.size());
            baby = (AgeableMob)possible.get(random).m_20615_((Level)serverLevel);
        }
        if (ageableMob instanceof EntityResourcefulCreeper) {
            EntityResourcefulCreeper entityResourcefulCreeper = (EntityResourcefulCreeper)ageableMob;
            entityResourcefulCreeper.setTamed();
        }
        return baby;
    }

    public void m_27563_(ServerLevel serverLevel, Animal animal) {
        AgeableMob ageableMob = this.m_142606_(serverLevel, (AgeableMob)animal);
        if (ageableMob != null) {
            ServerPlayer serverPlayer = this.m_27592_();
            if (serverPlayer == null && animal.m_27592_() != null) {
                serverPlayer = animal.m_27592_();
            }
            if (serverPlayer != null) {
                serverPlayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverPlayer, (Animal)this, animal, ageableMob);
            }
            this.m_146762_(6000);
            animal.m_146762_(6000);
            this.m_27594_();
            animal.m_27594_();
            ageableMob.m_6863_(true);
            ageableMob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            if (ageableMob instanceof EntityResourcefulCreeper) {
                EntityResourcefulCreeper entityResourcefulCreeper = (EntityResourcefulCreeper)ageableMob;
                entityResourcefulCreeper.setTamed();
            }
            serverLevel.m_47205_((Entity)ageableMob);
            serverLevel.m_7605_((Entity)this, (byte)18);
            if (serverLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
                serverLevel.m_7967_((Entity)new ExperienceOrb((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
            }
        }
    }

    public List<EntityType<?>> getFromTier(int tier, Level level) {
        ArrayList list = new ArrayList();
        ModEntities.STORED_TYPES.forEach((entityType, integer) -> {
            EntityResourcefulCreeper creeper = (EntityResourcefulCreeper)entityType.m_20615_(level);
            if (creeper.getCreeperType().getTier() == tier) {
                list.add((EntityType<?>)entityType);
            }
        });
        return list;
    }

    public float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return this.m_6162_() ? entityDimensions.f_20378_ * 0.85f : 1.45f;
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_TAMED, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            compoundTag.m_128379_("powered", true);
        }
        compoundTag.m_128376_("Fuse", (short)this.maxSwell);
        compoundTag.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        compoundTag.m_128379_("ignited", this.isIgnited());
        compoundTag.m_128379_("tamed", this.isTamed());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)compoundTag.m_128471_("powered"));
        if (compoundTag.m_128425_("Fuse", 99)) {
            this.maxSwell = compoundTag.m_128448_("Fuse");
        }
        if (compoundTag.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compoundTag.m_128445_("ExplosionRadius");
        }
        if (compoundTag.m_128471_("ignited")) {
            this.ignite();
        }
        if (compoundTag.m_128471_("tamed")) {
            this.setTamed();
        }
    }

    public boolean m_8028_() {
        if (this.isTamed()) {
            return false;
        }
        return !this.m_6162_();
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11836_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    public boolean m_5545_(LevelAccessor levelAccessor, MobSpawnType mobSpawnType) {
        return true;
    }

    public boolean m_6914_(LevelReader arg) {
        return !arg.m_46855_(this.m_142469_()) && arg.m_45784_((Entity)this);
    }

    public int m_5792_() {
        return 4;
    }

    public boolean m_6785_(double d) {
        return true;
    }
}

