/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.creeperhost.resourcefulcreepers.Constants;
import net.creeperhost.resourcefulcreepers.data.CreeperType;
import org.apache.commons.io.IOUtils;

public class CreeperTypeList {
    public static CreeperTypeList INSTANCE;
    public List<CreeperType> creeperTypes = new ArrayList<CreeperType>();

    public void add(CreeperType creeperType) {
        this.creeperTypes.add(creeperType);
    }

    public static String saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson((Object)INSTANCE);
    }

    public static void loadFromFile(File file) {
        Gson gson = new Gson();
        try {
            FileReader fileReader = new FileReader(file);
            INSTANCE = (CreeperTypeList)gson.fromJson((Reader)fileReader, CreeperTypeList.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void init(File file) {
        try {
            if (!file.exists()) {
                INSTANCE = new CreeperTypeList();
                FileWriter tileWriter = new FileWriter(file);
                tileWriter.write(CreeperTypeList.saveConfig());
                tileWriter.close();
            } else {
                CreeperTypeList.loadFromFile(file);
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    public static void writeToFile(String json) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(Constants.CREEPER_TYPES_CONFIG.toFile());){
            IOUtils.write((String)json, (OutputStream)fileOutputStream, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void updateFile() {
        CreeperTypeList.writeToFile(CreeperTypeList.saveConfig());
    }
}

