/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.data;

import java.util.ArrayList;
import java.util.List;
import net.creeperhost.resourcefulcreepers.data.ItemDrop;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CreeperType {
    private final String name;
    private final String displayName;
    private final int tier;
    private final int spawnEggColour1;
    private final int spawnEggColour2;
    private final boolean dropItemsOnDeath;
    private final int spawnWeight;
    private final boolean allowNaturalSpawns;
    private final double armourValue;
    private final List<ItemDrop> itemDrops;

    public CreeperType(String name, String displayName, int tier, int spawnEggColour1, int spawnEggColour2, boolean dropItemsOnDeath, int spawnWeight, boolean allowNaturalSpawns, double armourValue, List<ItemDrop> itemDrops) {
        this.name = name;
        this.displayName = displayName;
        this.tier = tier;
        this.spawnEggColour1 = spawnEggColour1;
        this.spawnEggColour2 = spawnEggColour2;
        this.dropItemsOnDeath = dropItemsOnDeath;
        this.spawnWeight = spawnWeight;
        this.allowNaturalSpawns = allowNaturalSpawns;
        this.armourValue = armourValue;
        this.itemDrops = itemDrops;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getSpawnEggColour1() {
        return this.spawnEggColour1;
    }

    public int getSpawnEggColour2() {
        return this.spawnEggColour2;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean shouldDropItemsOnDeath() {
        return this.dropItemsOnDeath;
    }

    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public boolean allowNaturalSpawns() {
        return this.allowNaturalSpawns;
    }

    public double getArmourValue() {
        return this.armourValue;
    }

    public List<ItemDrop> getItemDrops() {
        return this.itemDrops;
    }

    public ArrayList<ItemStack> getItemDropsAsList() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (ItemDrop itemDrop : this.getItemDrops()) {
            Item item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(itemDrop.getName()));
            if (item == null || item == Items.f_41852_) continue;
            itemStacks.add(new ItemStack((ItemLike)item, itemDrop.getAmount()));
        }
        return itemStacks;
    }
}

