/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class Config {
    public static Config INSTANCE;
    public boolean generateDefaultTypes = true;
    public boolean autoGenerateCreeperTypesFromOreTags = false;
    public float explosionMultiplier = 0.25f;
    public float poweredExplosionMultiplier = 0.5f;
    public boolean explosionsGenerateOres = true;
    public boolean overrideOreDrops = false;
    public boolean creepersAttractedToArmourStand = true;
    public boolean disableSentry = false;
    public boolean nonHostileWhenTamed = false;

    public static String saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson((Object)INSTANCE);
    }

    public static void loadFromFile(File file) {
        Gson gson = new Gson();
        try {
            FileReader fileReader = new FileReader(file);
            INSTANCE = (Config)gson.fromJson((Reader)fileReader, Config.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveConfigToFile(File file) {
        try (FileOutputStream configOut = new FileOutputStream(file);){
            IOUtils.write((String)Config.saveConfig(), (OutputStream)configOut, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void init(File file) {
        try {
            if (!file.exists()) {
                INSTANCE = new Config();
                FileWriter tileWriter = new FileWriter(file);
                tileWriter.write(Config.saveConfig());
                tileWriter.close();
            } else {
                Config.loadFromFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

