/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.creeperhost.resourcefulcreepers.client.ResourcefulCreeperClient;
import net.creeperhost.resourcefulcreepers.client.ResourcefulCreeperModel;
import net.creeperhost.resourcefulcreepers.client.ResourcefulCreeperPowerLayer;
import net.creeperhost.resourcefulcreepers.entites.EntityResourcefulCreeper;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class ResourcefulCreeperRender
extends MobRenderer<EntityResourcefulCreeper, ResourcefulCreeperModel<EntityResourcefulCreeper>>
implements RenderLayerParent<EntityResourcefulCreeper, ResourcefulCreeperModel<EntityResourcefulCreeper>> {
    public static final ResourceLocation CREEPER_LOCATION = new ResourceLocation("textures/entity/creeper/creeper.png");

    public ResourcefulCreeperRender(EntityRendererProvider.Context context) {
        super(context, new ResourcefulCreeperModel(context.m_174023_(ModelLayers.f_171285_)), 0.5f);
        this.m_115326_((RenderLayer)new ResourcefulCreeperPowerLayer(this, context.m_174027_()));
    }

    public float getWhiteOverlayProgress(EntityResourcefulCreeper creeper, float f) {
        float g = creeper.getSwelling(f);
        return (int)(g * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)g, (float)0.5f, (float)1.0f);
    }

    public void scale(EntityResourcefulCreeper arg, PoseStack arg2, float f) {
        float g = arg.getSwelling(f);
        float h = 1.0f + Mth.m_14031_((float)(g * 100.0f)) * g * 0.01f;
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        g *= g;
        g *= g;
        float i = (1.0f + g * 0.4f) * h;
        float j = (1.0f + g * 0.1f) / h;
        arg2.m_85841_(i, j, i);
    }

    public ResourceLocation getTextureLocation(EntityResourcefulCreeper entity) {
        String resourceName = entity.getCreeperType().getName();
        if (ResourcefulCreeperClient.getTexture(resourceName) == null) {
            return CREEPER_LOCATION;
        }
        return new ResourceLocation("resourcefulcreepers", "/textures/entities/" + entity.getCreeperType().getName());
    }

    public void render(EntityResourcefulCreeper mob, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        super.m_7392_((Mob)mob, f, g, poseStack, multiBufferSource, i);
    }
}

