/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ResourcefulCreeperModel<EntityResourcefulCreeper extends Entity>
extends AgeableListModel<EntityResourcefulCreeper> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private static final int Y_OFFSET = 6;

    public ResourcefulCreeperModel(ModelPart modelPart) {
        this.root = modelPart;
        this.head = modelPart.m_171324_("head");
        this.leftHindLeg = modelPart.m_171324_("right_hind_leg");
        this.rightHindLeg = modelPart.m_171324_("left_hind_leg");
        this.leftFrontLeg = modelPart.m_171324_("right_front_leg");
        this.rightFrontLeg = modelPart.m_171324_("left_front_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        CubeListBuilder cubeListBuilder = CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation);
        partDefinition.m_171599_("right_hind_leg", cubeListBuilder, PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)4.0f));
        partDefinition.m_171599_("left_hind_leg", cubeListBuilder, PartPose.m_171419_((float)2.0f, (float)18.0f, (float)4.0f));
        partDefinition.m_171599_("right_front_leg", cubeListBuilder, PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)-4.0f));
        partDefinition.m_171599_("left_front_leg", cubeListBuilder, PartPose.m_171419_((float)2.0f, (float)18.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void m_6973_(EntityResourcefulCreeper entity, float f, float g, float h, float i, float j) {
        this.head.f_104204_ = i * ((float)Math.PI / 180);
        this.head.f_104203_ = j * ((float)Math.PI / 180);
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.head, (Object)this.root, (Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg);
    }
}

