/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.resourcefulcreepers;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.creeperhost.resourcefulcreepers.ResourcefulCreepers;
import net.creeperhost.resourcefulcreepers.ResourcefulCreepersExpectPlatform;
import net.creeperhost.resourcefulcreepers.data.CreeperType;
import net.creeperhost.resourcefulcreepers.data.CreeperTypeList;
import net.creeperhost.resourcefulcreepers.data.OreGenData;
import net.creeperhost.resourcefulcreepers.mixin.MixinCountPlacement;
import net.creeperhost.resourcefulcreepers.mixin.MixinHeightRangePlacement;
import net.creeperhost.resourcefulcreepers.mixin.MixinTrapezoidHeight;
import net.creeperhost.resourcefulcreepers.mixin.MixinUniformHeight;
import net.creeperhost.resourcefulcreepers.util.ColorHelper;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;

public class CreeperBuilder {
    public static HashMap<ResourceLocation, OreGenData> ORE_DATA = new HashMap();
    public static int MAX_TIER = 0;

    public static int generateFromOreTags() {
        CreeperBuilder.generateOreData();
        MAX_TIER = ResourcefulCreepersExpectPlatform.getTierList().size();
        CreeperTypeList.INSTANCE.creeperTypes.clear();
        List<Block> defaults = ResourcefulCreepersExpectPlatform.getDefaults();
        int amount = 0;
        for (Block aDefault : defaults) {
            ResourceLocation empty;
            ResourceLocation name = Registry.f_122824_.m_7981_((Object)aDefault);
            if (name == (empty = new ResourceLocation("empty"))) {
                ResourcefulCreepers.LOGGER.error("Unable to find blocks resource location for " + name + " Skipping");
                continue;
            }
            OreGenData oreGenData = ORE_DATA.get(name);
            if (oreGenData == null) {
                ResourcefulCreepers.LOGGER.error("Unable to find oreData for " + name + " Skipping");
                continue;
            }
            int tier = -1;
            if (CreeperBuilder.calculateTier(aDefault.m_49966_()) >= 0) {
                tier = CreeperBuilder.calculateTier(aDefault.m_49966_());
                if (tier > MAX_TIER) {
                    tier = MAX_TIER;
                }
            } else {
                ResourcefulCreepers.LOGGER.error("Unable to find calculate tier for " + name + " Skipping");
                continue;
            }
            CreeperType creeperType = new CreeperType(name.m_135815_(), aDefault.m_49954_().getString(), tier, ResourcefulCreepers.DEFAULT_COLOUR, ColorHelper.getRandomColour(new ItemStack((ItemLike)aDefault)), true, oreGenData.getWeight(), true, aDefault.m_155943_(), ResourcefulCreepers.createSingleList(name.toString(), 1));
            CreeperTypeList.INSTANCE.creeperTypes.add(creeperType);
            ++amount;
        }
        CreeperTypeList.updateFile();
        return amount;
    }

    public static void generateOreData() {
        BuiltinRegistries.f_194653_.forEach(configuredFeature -> configuredFeature.m_191781_().forEach(configuredFeature1 -> {
            FeatureConfiguration patt3893$temp = configuredFeature1.f_65378_();
            if (patt3893$temp instanceof OreConfiguration) {
                OreConfiguration oreConfiguration = (OreConfiguration)patt3893$temp;
                AtomicInteger minWeight = new AtomicInteger();
                AtomicInteger minY = new AtomicInteger();
                AtomicInteger maxY = new AtomicInteger();
                configuredFeature.f_191776_().forEach(placementModifier -> {
                    if (placementModifier instanceof CountPlacement) {
                        CountPlacement countPlacement = (CountPlacement)placementModifier;
                        IntProvider intProvider = ((MixinCountPlacement)countPlacement).getcount();
                        minWeight.set(intProvider.m_142737_());
                    }
                    if (placementModifier instanceof HeightRangePlacement) {
                        VerticalAnchor verticalAnchor2;
                        VerticalAnchor verticalAnchor;
                        HeightRangePlacement heightRangePlacement = (HeightRangePlacement)placementModifier;
                        HeightProvider heightProvider = ((MixinHeightRangePlacement)heightRangePlacement).getheight();
                        if (heightProvider instanceof UniformHeight) {
                            UniformHeight uniformHeight = (UniformHeight)heightProvider;
                            verticalAnchor = ((MixinUniformHeight)uniformHeight).getminInclusive();
                            verticalAnchor2 = ((MixinUniformHeight)uniformHeight).getmaxInclusive();
                            minY.set(0);
                            maxY.set(0);
                        }
                        if (heightProvider instanceof TrapezoidHeight) {
                            TrapezoidHeight trapezoidHeight = (TrapezoidHeight)heightProvider;
                            verticalAnchor = ((MixinTrapezoidHeight)trapezoidHeight).getminInclusive();
                            verticalAnchor2 = ((MixinTrapezoidHeight)trapezoidHeight).getmaxInclusive();
                            minY.set(0);
                            maxY.set(0);
                        }
                    }
                });
                oreConfiguration.f_161005_.forEach(targetBlockState -> {
                    ResourceLocation name = Registry.f_122824_.m_7981_((Object)targetBlockState.f_161033_.m_60734_());
                    ORE_DATA.put(name, new OreGenData(oreConfiguration.f_67839_, minWeight.get(), minY.get(), maxY.get()));
                });
            }
        }));
    }

    public static int calculateTier(BlockState blockState) {
        List<Tier> tierList = ResourcefulCreepersExpectPlatform.getTierList();
        for (Tier tier : tierList) {
            if (!ResourcefulCreepersExpectPlatform.isCorrectTierForDrops(tier, blockState)) continue;
            return tier.m_6604_();
        }
        return 0;
    }
}

