/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.items;

import com.flanks255.psu.gui.PSUContainer;
import com.flanks255.psu.inventory.PSUData;
import com.flanks255.psu.inventory.PSUItemHandler;
import com.flanks255.psu.inventory.StorageManager;
import com.flanks255.psu.items.PSUTier;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class PocketStorageUnit
extends Item {
    private final PSUTier tier;
    private static final Random random = new Random();
    private long lastInteractMills = 0L;
    private BlockPos lastInteractPos = new BlockPos(0, 0, 0);

    public PocketStorageUnit(PSUTier tierIn) {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_));
        this.tier = tierIn;
    }

    public Rarity m_41460_(ItemStack pStack) {
        return this.tier.rarity;
    }

    private boolean hasTranslation(String key) {
        return !I18n.m_118938_((String)key, (Object[])new Object[0]).equals(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        String translationKey = this.m_5524_();
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent(translationKey + ".info", new Object[]{new TextComponent(String.valueOf(this.tier.slots)).m_130940_(ChatFormatting.GOLD), new TextComponent(String.valueOf(this.tier.capacity)).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
            if (this.hasTranslation(translationKey + ".info2")) {
                tooltip.add((Component)new TranslatableComponent(translationKey + ".info2").m_130940_(ChatFormatting.GRAY));
            }
            if (this.hasTranslation(translationKey + ".info3")) {
                tooltip.add((Component)new TranslatableComponent(translationKey + ".info3").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)new TranslatableComponent("pocketstorage.util.deposit", new Object[]{new TranslatableComponent("pocketstorage.util.sneak_right").m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)new TranslatableComponent("pocketstorage.util.withdraw", new Object[]{new TranslatableComponent("pocketstorage.util.sneak_left").m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent("pocketstorage.util.shift", new Object[]{new TranslatableComponent("pocketstorage.util.key_shift").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC})}).m_130940_(ChatFormatting.GRAY));
        }
        if (flagIn.m_7050_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("UUID")) {
            UUID uuid = stack.m_41783_().m_128342_("UUID");
            tooltip.add((Component)new TextComponent("ID: " + uuid.toString().substring(0, 8)).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PSUCaps(stack);
    }

    public boolean pickupEvent(EntityItemPickupEvent event, ItemStack stack) {
        Optional<PSUItemHandler> handlerOpt = StorageManager.get().getHandler(stack);
        return handlerOpt.map(handler -> {
            ItemStack pickedUp = event.getItem().m_32055_();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slot = handler.getStackInSlot(i);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot, (ItemStack)pickedUp)) continue;
                handler.insertItem(i, pickedUp, false);
                pickedUp.m_41764_(0);
                return true;
            }
            return false;
        }).orElse(false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        this.openGUI(worldIn, playerIn, handIn);
        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().f_46443_) {
            Level world = context.m_43725_();
            BlockState bs = world.m_8055_(context.m_8083_());
            if (bs.m_155947_() && context.m_43723_() != null && context.m_43723_().m_6047_() && world.m_7702_(context.m_8083_()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                BlockEntity te = world.m_7702_(context.m_8083_());
                LazyOptional chestOptional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                Optional<PSUItemHandler> handler = StorageManager.get().getHandler(context.m_43722_());
                handler.ifPresent(my -> chestOptional.ifPresent(chest -> {
                    boolean movedItems = false;
                    for (int i = 0; i < my.getSlots(); ++i) {
                        ItemStack stack = my.getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        ItemStack backup = my.getStackInSlot(i);
                        backup.m_41764_(1);
                        stack.m_41764_(stack.m_41613_() - 1);
                        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)chest, (ItemStack)stack, (boolean)false);
                        movedItems = true;
                        if (remainder.m_41619_()) {
                            my.getSlot(i).setCount(1);
                            continue;
                        }
                        my.getSlot(i).setCount(remainder.m_41613_() + 1);
                    }
                    if (movedItems) {
                        context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.5f, 0.5f + random.nextFloat() * 0.5f);
                        context.m_43723_().m_21011_(context.m_43724_(), true);
                    }
                }));
            } else {
                this.openGUI(context.m_43725_(), context.m_43723_(), context.m_43724_());
            }
        }
        return InteractionResult.FAIL;
    }

    public void onLeftClickEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getPlayer().m_6047_() || event.getWorld().f_46443_) {
            return;
        }
        if (this.lastInteractPos.compareTo((Vec3i)event.getPos()) != 0) {
            this.onLeftClick(event);
        } else if (System.currentTimeMillis() - this.lastInteractMills > 1000L) {
            this.onLeftClick(event);
        }
        this.lastInteractMills = System.currentTimeMillis();
        this.lastInteractPos = event.getPos();
    }

    private void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Level world;
        BlockState bs;
        if (!event.getWorld().f_46443_ && (bs = (world = event.getWorld()).m_8055_(event.getPos())).m_155947_()) {
            BlockEntity te = world.m_7702_(event.getPos());
            LazyOptional chestOptional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            Optional<PSUItemHandler> handler = StorageManager.get().getHandler(event.getPlayer().m_21205_());
            handler.ifPresent(my -> chestOptional.ifPresent(chest -> {
                boolean movedItems = false;
                for (int i = 0; i < chest.getSlots(); ++i) {
                    ItemStack stack = chest.getStackInSlot(i);
                    if (stack.m_41619_() || !my.hasItem(stack)) continue;
                    ItemStack newStack = chest.extractItem(i, stack.m_41613_(), false);
                    my.insertItemSlotless(newStack, false, false);
                    movedItems = true;
                }
                if (movedItems) {
                    event.getWorld().m_5594_(null, event.getPos(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.5f, 0.5f + random.nextFloat() * 0.5f);
                }
            }));
        }
    }

    public static PSUData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.m_41720_() instanceof PocketStorageUnit)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("UUID")) {
            uuid = UUID.randomUUID();
            tag.m_128362_("UUID", uuid);
        } else {
            uuid = tag.m_128342_("UUID");
        }
        return StorageManager.get().getOrCreateStorage(uuid, ((PocketStorageUnit)stack.m_41720_()).tier);
    }

    private void openGUI(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_ && playerIn instanceof ServerPlayer && stack.m_41720_() instanceof PocketStorageUnit) {
            PSUData data = PocketStorageUnit.getData(stack);
            PSUTier tier = ((PocketStorageUnit)stack.m_41720_()).tier;
            UUID uuid = data.getUuid();
            if (stack.m_41784_().m_128441_("Slots")) {
                data.getHandler().deserializeNBT(stack.m_41783_());
                stack.m_41783_().m_128473_("Slots");
                StorageManager.get().m_77762_();
                playerIn.m_6352_((Component)new TranslatableComponent("pocketstorage.util.migration"), Util.f_137441_);
            }
            data.updateAccessRecords(playerIn.m_7755_().getString(), System.currentTimeMillis());
            if (data.getTier().ordinal() < tier.ordinal()) {
                data.upgrade(tier);
                playerIn.m_6352_((Component)new TranslatableComponent("pocketstorage.util.upgrade"), Util.f_137441_);
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new PSUContainer(windowId, playerInventory, uuid, data.getHandler()), stack.m_41786_()), packetBuffer -> packetBuffer.m_130079_(data.getHandler().serializeNBT()).m_130077_(uuid).writeInt(data.getTier().ordinal()));
        }
    }

    static class PSUCaps
    implements ICapabilityProvider {
        private final ItemStack stack;
        private LazyOptional<IItemHandler> lazyOptional = LazyOptional.empty();

        public PSUCaps(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (!this.lazyOptional.isPresent()) {
                    this.lazyOptional = StorageManager.get().getCapability(this.stack);
                }
                return this.lazyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

