/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.inventory;

import com.flanks255.psu.inventory.PSUData;
import com.flanks255.psu.inventory.PSUItemHandler;
import com.flanks255.psu.items.PSUTier;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class StorageManager
extends SavedData {
    private static final String NAME = "pocketstorage_data";
    private static final HashMap<UUID, PSUData> data = new HashMap();
    public static final StorageManager blankClient = new StorageManager();

    public static StorageManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (StorageManager)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(StorageManager::load, StorageManager::new, NAME);
        }
        return blankClient;
    }

    public HashMap<UUID, PSUData> getMap() {
        return data;
    }

    public Optional<PSUData> getStorage(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public PSUData getOrCreateStorage(UUID uuid, PSUTier tier) {
        return data.computeIfAbsent(uuid, id -> {
            this.m_77762_();
            return new PSUData((UUID)id, tier);
        });
    }

    public LazyOptional<IItemHandler> getCapability(UUID uuid) {
        if (data.containsKey(uuid)) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public Optional<PSUItemHandler> getHandler(ItemStack stack) {
        UUID uuid;
        if (stack.m_41784_().m_128441_("UUID") && data.containsKey(uuid = stack.m_41783_().m_128342_("UUID"))) {
            return Optional.of(data.get(uuid).getHandler());
        }
        return Optional.empty();
    }

    public LazyOptional<IItemHandler> getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.m_41784_().m_128441_("UUID") && data.containsKey(uuid = stack.m_41783_().m_128342_("UUID"))) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public static StorageManager load(CompoundTag nbt) {
        if (nbt.m_128441_("PSUS")) {
            ListTag list = nbt.m_128437_("PSUS", 10);
            list.forEach(psuNBT -> PSUData.fromNBT((CompoundTag)psuNBT).ifPresent(psu -> data.put(psu.getUuid(), (PSUData)psu)));
        }
        return new StorageManager();
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag backpacks = new ListTag();
        data.forEach((uuid, backpackData) -> backpacks.add((Object)backpackData.toNBT()));
        compound.m_128365_("PSUS", (Tag)backpacks);
        return compound;
    }
}

