/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.gui;

import com.flanks255.psu.PocketStorage;
import com.flanks255.psu.gui.LockableSlot;
import com.flanks255.psu.inventory.PSUItemHandler;
import com.flanks255.psu.items.PSUTier;
import com.flanks255.psu.util.PSUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class PSUContainer
extends AbstractContainerMenu {
    public PSUItemHandler handler;
    private final Inventory playerInv;
    private final UUID uuid;

    public static PSUContainer fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        CompoundTag nbt = data.m_130261_();
        UUID uuidIn = data.m_130259_();
        PSUTier tier = PSUTier.values()[data.readInt()];
        PSUItemHandler handler = new PSUItemHandler(tier);
        handler.deserializeNBT(nbt);
        return new PSUContainer(windowId, playerInventory, uuidIn, handler);
    }

    public PSUContainer(int windowId, Inventory playerInventory, UUID uuidIn, PSUItemHandler handlerIn) {
        super((MenuType)PocketStorage.PSUCONTAINER.get(), windowId);
        this.uuid = uuidIn;
        this.playerInv = playerInventory;
        this.handler = handlerIn;
        this.addPlayerSlots(playerInventory);
    }

    public void m_150399_(int slot, int dragType, ClickType clickTypeIn, Player player) {
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        if (slot >= 0) {
            this.m_38853_((int)slot).f_40218_.m_6596_();
        }
        super.m_150399_(slot, dragType, clickTypeIn, player);
    }

    public void networkSlotClick(int slot, boolean shift, boolean ctrl, boolean rightClick) {
        if (slot >= 0 && slot <= this.handler.getSlots()) {
            if (!this.m_142621_().m_41619_()) {
                ItemStack tmp;
                ItemStack incoming = this.m_142621_();
                if (incoming.m_41782_() && this.playerInv.f_35978_.f_19853_.m_5776_()) {
                    this.playerInv.f_35978_.m_6352_((Component)new TranslatableComponent("pocketstorage.util.no_data_items"), Util.f_137441_);
                    return;
                }
                if (rightClick) {
                    ItemStack single = incoming.m_41620_(1);
                    ItemStack remainder = this.handler.insertItem(slot, single, false);
                    if (!remainder.m_41619_()) {
                        incoming.m_41769_(1);
                    }
                    this.m_142503_(incoming);
                } else if (!ctrl) {
                    this.m_142503_(this.handler.insertItem(slot, incoming, false));
                } else if (incoming.m_41613_() < incoming.m_41741_() && incoming.m_41656_(this.handler.getStackInSlot(slot)) && !(tmp = this.handler.extractItem(slot, 1, false)).m_41619_()) {
                    incoming.m_41764_(incoming.m_41613_() + 1);
                    this.m_142503_(incoming);
                }
            } else {
                int extract;
                int n = extract = ctrl ? 1 : 64;
                if (rightClick) {
                    extract = Math.min(this.handler.getStackInSlot(slot).m_41613_() / 2, 32);
                }
                ItemStack tmp = this.handler.extractItem(slot, extract, false);
                if (!shift) {
                    if (!tmp.m_41619_()) {
                        this.m_142503_(tmp);
                    }
                } else if (!tmp.m_41619_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)this.playerInv.f_35978_, (ItemStack)tmp);
                }
            }
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            return this.handler.insertItemSlotless(slot.m_7993_(), true, true);
        }
        return ItemStack.f_41583_;
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int originX = 7;
        int originY = 97;
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            Optional<UUID> uuidOptional = PSUtils.getUUID((ItemStack)playerInventory.f_35974_.get(col));
            boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
            this.m_38897_(new LockableSlot((Container)playerInventory, col, x + 1, y + 1, lockMe));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                int index = col + row * 9 + 9;
                Optional<UUID> uuidOptional = PSUtils.getUUID((ItemStack)playerInventory.f_35974_.get(index));
                boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
                this.m_38897_(new LockableSlot((Container)playerInventory, index, x + 1, y + 1, lockMe));
            }
        }
    }
}

