/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.verification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;

public class ModPackVerifier {
    String curseID = Config.getInstance().getCurseProjectID();
    String base64 = "";
    String requestedID = "";
    String ftbPackID = "";

    public String verify() {
        this.updateFtbPackID();
        HashMap<String, String> jsonObj = new HashMap<String, String>();
        if (this.ftbPackID.length() <= 1) {
            int packID;
            try {
                packID = Integer.parseInt(this.curseID);
            }
            catch (NumberFormatException e) {
                packID = -1;
            }
            jsonObj.put("p", String.valueOf(packID));
        } else {
            jsonObj.put("p", this.ftbPackID);
            jsonObj.put("b", this.base64);
            MineTogetherCommon.base64 = this.base64;
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        try {
            String realName = gson.toJson(jsonObj);
            return realName;
        }
        catch (Exception e) {
            Sentry.captureException(e);
            return "{\"p\": \"-1\"}";
        }
    }

    public void updateFtbPackID() {
        File versions = new File(Platform.getGameFolder() + File.separator + "version.json");
        if (versions.exists()) {
            try (FileInputStream stream = new FileInputStream(versions);){
                try {
                    JsonObject json = new JsonParser().parse((Reader)new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8)).getAsJsonObject();
                    if (json.isJsonObject()) {
                        JsonObject object = json.getAsJsonObject();
                        int versionID = object.getAsJsonPrimitive("id").getAsInt();
                        int ftbPackID = object.getAsJsonPrimitive("parent").getAsInt();
                        this.base64 = Base64.getEncoder().encodeToString((String.valueOf(ftbPackID) + String.valueOf(versionID)).getBytes());
                        this.requestedID = ChatCallbacks.getVersionFromApi(this.base64);
                        if (this.requestedID.isEmpty()) {
                            this.requestedID = "-1";
                        }
                        Config.instance.curseProjectID = this.requestedID;
                        Config.saveConfigToFile(MineTogetherCommon.configFile.toFile());
                        this.ftbPackID = "m" + ftbPackID;
                    }
                }
                catch (Exception MalformedJsonException) {
                    Sentry.captureException(MalformedJsonException);
                    MineTogetherCommon.logger.error("version.json is not valid returning to curse ID");
                }
            }
            catch (IOException e) {
                Sentry.captureException(e);
                MineTogetherCommon.logger.info("version.json not found returning to curse ID");
            }
        }
    }
}

