/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.threads;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.io.sentry.SentryLevel;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.util.WebUtils;

public class FriendUpdateThread {
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    public static void init() {
        Runnable runnable = FriendUpdateThread::updateFriendsList;
        executorService.scheduleAtFixedRate(runnable, 60L, 60L, TimeUnit.SECONDS);
    }

    public static void updateFriendsList() {
        if (MineTogetherChat.INSTANCE == null) {
            return;
        }
        String resp = "empty";
        try {
            JsonObject obj;
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("hash", MineTogetherChat.INSTANCE.hash);
            resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/listfriend", new Gson().toJson(sendMap), true, true, 20000);
            JsonElement el = new JsonParser().parse(resp);
            if (el.isJsonObject() && (obj = el.getAsJsonObject()).get("status").getAsString().equals("success")) {
                JsonArray array = obj.getAsJsonArray("friends");
                for (JsonElement friendEl : array) {
                    String code;
                    JsonObject friend = (JsonObject)friendEl;
                    String name = "null";
                    if (!friend.get("name").isJsonNull()) {
                        name = friend.get("name").getAsString();
                    }
                    String string = code = friend.get("hash").isJsonNull() ? "" : friend.get("hash").getAsString();
                    boolean accepted = friend.get("accepted").getAsBoolean();
                    if (!accepted) continue;
                    Profile friendProfile = KnownUsers.findByHash(code);
                    if (friendProfile == null) {
                        friendProfile = KnownUsers.add(code);
                    }
                    if (friendProfile == null) continue;
                    friendProfile.setFriendName(name);
                    friendProfile.setFriend(true);
                    KnownUsers.update(friendProfile);
                }
            }
        }
        catch (Exception e) {
            Sentry.setLevel(SentryLevel.WARNING);
            Sentry.setExtra("resp", resp);
            MineTogetherCommon.sentryException(e);
        }
    }

    public static void stop() {
        try {
            executorService.shutdownNow();
        }
        catch (Exception e) {
            MineTogetherCommon.sentryException(e);
        }
    }
}

