/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.oauth.KeycloakOAuth;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class SettingsScreen
extends MineTogetherScreen {
    private final Screen parent;
    private Button linkButton;

    public SettingsScreen(Screen parent) {
        super((Component)new TranslatableComponent("minetogether.settings.title"));
        this.parent = parent;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 123, 40, 120, 20, (Component)new TranslatableComponent(I18n.m_118938_((String)("Chat Enabled: " + this.format(Config.getInstance().isChatEnabled())), (Object[])new Object[0])), p -> {
            if (Config.getInstance().isChatEnabled()) {
                MineTogetherCommon.logger.info("Disabling in-game chat");
                IrcHandler.sendString("QUIT Game closed", false);
                Config.getInstance().setChatEnabled(false);
                IrcHandler.stop(true);
            } else {
                MineTogetherCommon.logger.info("Enabling in-game chat");
                Config.getInstance().setChatEnabled(true);
                IrcHandler.reconnect();
                ChatModule.getMineTogetherChat().startChat();
            }
            this.saveConfig();
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 3, 40, 120, 20, (Component)new TranslatableComponent(I18n.m_118938_((String)("Friend Toasts: " + this.format(Config.getInstance().isFriendOnlineToastsEnabled())), (Object[])new Object[0])), p -> {
            boolean enabled = Config.getInstance().isFriendOnlineToastsEnabled();
            Config.getInstance().setEnableFriendOnlineToasts(!enabled);
            this.saveConfig();
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 123, 60, 120, 20, (Component)new TranslatableComponent(I18n.m_118938_((String)("Menu Buttons: " + this.format(Config.getInstance().isEnableMainMenuFriends())), (Object[])new Object[0])), p -> {
            boolean enabled = Config.getInstance().isEnableMainMenuFriends();
            Config.getInstance().setEnableMainMenuFriends(!enabled);
            this.saveConfig();
        }));
        this.linkButton = new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 47, 200, 20, (Component)new TranslatableComponent(I18n.m_118938_((String)"minetogether.settingscreen.button.linkaccount", (Object[])new Object[0])), p -> this.f_96541_.m_91152_((Screen)new ConfirmScreen(e -> {
            if (e) {
                KeycloakOAuth.main(new String[0]);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, (Component)new TranslatableComponent(I18n.m_118938_((String)"minetogether.linkaccount1", (Object[])new Object[0])), (Component)new TranslatableComponent(I18n.m_118938_((String)"minetogether.linkaccount2", (Object[])new Object[0])))));
        this.m_142416_((GuiEventListener)this.linkButton);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20, (Component)new TranslatableComponent(I18n.m_118938_((String)"gui.done", (Object[])new Object[0])), p -> this.f_96541_.m_91152_(this.parent)));
    }

    public void m_96624_() {
        this.linkButton.f_93623_ = Config.getInstance().getFirstConnect();
        super.m_96624_();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_96626_(1);
        super.m_6305_(poseStack, i, j, f);
        SettingsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
    }

    public String format(boolean value) {
        return value ? ChatFormatting.GREEN + "Enabled" : ChatFormatting.RED + "Disabled";
    }

    private void saveConfig() {
        Config.saveConfigToFile(MineTogetherCommon.configFile.toFile());
        this.f_96541_.m_91152_((Screen)new SettingsScreen(this.parent));
    }
}

