/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.creeperhost.minetogether.lib.serverorder.DefferedValidation;
import net.creeperhost.minetogether.lib.serverorder.IOrderValidation;
import net.creeperhost.minetogether.lib.serverorder.Pair;
import net.creeperhost.minetogether.module.serverorder.screen.PersonalDetailsScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class TextFieldDetails
extends EditBox {
    private final PersonalDetailsScreen gui;
    private final String displayString;
    private final boolean canBeFocused;
    private final int ourID;
    public boolean isValidated;
    public String validationError = "";
    private String censorText = "";
    private boolean isChangeValidated = false;
    private final String acceptString = new String(Character.toChars(10004));
    private final String denyString = new String(Character.toChars(10006));
    private final ArrayList<IOrderValidation> validators;
    private boolean doNotValidate = false;
    private DefferedValidation pendingValidation = null;

    public TextFieldDetails(PersonalDetailsScreen gui, int id, String displayString, String def, int x, int y, int width, int height, ArrayList<IOrderValidation> validators, boolean canBeFocused) {
        super(Minecraft.m_91087_().f_91062_, x, y, width, height, (Component)new TranslatableComponent(""));
        this.ourID = id;
        this.validators = validators;
        this.gui = gui;
        this.canBeFocused = canBeFocused;
        this.displayString = displayString;
        this.m_94144_(def);
        this.m_93692_(true);
        this.m_93692_(false);
        this.m_94199_(64);
    }

    public TextFieldDetails(PersonalDetailsScreen gui, int id, String displayString, String def, int x, int y, int width, int height, ArrayList<IOrderValidation> validators, String censorText) {
        this(gui, id, displayString, def, x, y, width, height, validators);
        this.censorText = censorText;
    }

    public TextFieldDetails(PersonalDetailsScreen gui, int id, String displayString, String def, int x, int y, int width, int height, ArrayList<IOrderValidation> validators) {
        this(gui, id, displayString, def, x, y, width, height, validators, true);
    }

    public void checkPendingValidations() {
        if (this.pendingValidation != null && this.pendingValidation.isDone()) {
            this.gui.validationChangedDeferred(this, this.pendingValidation);
            this.isValidated = this.pendingValidation.isValid("");
            this.validationError = this.pendingValidation.getValidationMessage();
            this.pendingValidation.reset();
            this.pendingValidation = null;
        }
    }

    public int getId() {
        return this.ourID;
    }

    public void m_6305_(PoseStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (!this.censorText.isEmpty()) {
            String text = this.m_94155_();
            double censorLength = this.censorText.length();
            double mainLength = text.length();
            double timesRaw = mainLength / censorLength;
            int times = (int)Math.ceil(timesRaw);
            String obscure = new String(new char[times]).replace("\u0000", this.censorText).substring(0, (int)mainLength);
            boolean oldNotValidate = this.doNotValidate;
            this.doNotValidate = true;
            this.m_94144_(obscure);
            super.m_6305_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
            this.m_94144_(text);
            this.doNotValidate = oldNotValidate;
        } else {
            super.m_6305_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        }
        int startX = (this.f_93620_ + this.f_93618_ + 3) / 2;
        int startY = (this.f_93621_ + 4) / 2;
        matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        if (this.isValidated) {
            TextFieldDetails.m_93236_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)this.acceptString, (int)startX, (int)startY, (int)65280);
        } else {
            TextFieldDetails.m_93236_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)this.denyString, (int)startX, (int)startY, (int)0xFF0000);
        }
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        if (!this.m_93696_() && this.m_94155_().trim().isEmpty()) {
            int x = this.f_93620_ + 4;
            int y = this.f_93621_ + (this.f_93619_ - 8) / 2;
            Minecraft.m_91087_().f_91062_.m_92750_(matrixStack, "\u00a7o" + this.displayString, (float)x, (float)y, 0xE0E0E0);
        }
    }

    public boolean canBeFocused() {
        return this.canBeFocused;
    }

    private Pair<Boolean, IOrderValidation> validateAtPhase(IOrderValidation.ValidationPhase phase, String string, boolean ignoreAsync) {
        if (this.pendingValidation != null || this.doNotValidate) {
            return new Pair<Boolean, Object>(false, null);
        }
        boolean validatorsExist = false;
        for (IOrderValidation validator : this.validators) {
            if (!validatorsExist && !this.isChangeValidated && phase.equals((Object)IOrderValidation.ValidationPhase.FOCUSLOST)) {
                return new Pair<Boolean, Object>(false, null);
            }
            if (!validator.validationCheckAtPhase(phase)) continue;
            if (validator.isAsync()) {
                if (ignoreAsync) continue;
                this.pendingValidation = (DefferedValidation)validator;
                this.pendingValidation.setPhase(phase);
                this.pendingValidation.doAsync(string);
            }
            validatorsExist = true;
            if (validator.isValid(string)) continue;
            this.gui.validationChanged(this, false, validator, phase);
            return new Pair<Boolean, IOrderValidation>(true, validator);
        }
        if (validatorsExist) {
            this.gui.validationChanged(this, true, null, phase);
        }
        return new Pair<Boolean, Object>(validatorsExist, null);
    }

    private Pair<Boolean, IOrderValidation> validateAtPhase(IOrderValidation.ValidationPhase phase, String string) {
        return this.validateAtPhase(phase, string, false);
    }

    public void m_93692_(boolean focused) {
        Pair<Boolean, IOrderValidation> validatorPair;
        if (focused) {
            this.gui.focusedField = this;
            if (!this.canBeFocused) {
                return;
            }
        } else if (this.m_93696_() && (validatorPair = this.validateAtPhase(IOrderValidation.ValidationPhase.FOCUSLOST, this.m_94155_())).getLeft().booleanValue()) {
            IOrderValidation validator = validatorPair.getRight();
            if (validator != null) {
                this.validationError = validator.getValidationMessage();
                this.isValidated = false;
            } else {
                this.validationError = "This is fine";
                this.isValidated = true;
            }
        }
        super.m_93692_(focused);
    }

    public void m_94164_(String string) {
        super.m_94164_(string);
        Pair<Boolean, IOrderValidation> validatorPair = this.validateAtPhase(IOrderValidation.ValidationPhase.CHANGED, this.m_94155_());
        if (validatorPair.getLeft().booleanValue()) {
            IOrderValidation validator = validatorPair.getRight();
            if (validator != null) {
                this.validationError = validator.getValidationMessage();
                this.isValidated = false;
                this.isChangeValidated = false;
            } else {
                this.validationError = "This is fine";
                this.isValidated = true;
                this.isChangeValidated = true;
            }
        }
    }

    public void m_94144_(String string) {
        super.m_94144_(string);
        Pair<Boolean, IOrderValidation> validatorPair = this.validateAtPhase(IOrderValidation.ValidationPhase.CHANGED, this.m_94155_());
        if (validatorPair.getLeft().booleanValue()) {
            IOrderValidation validator = validatorPair.getRight();
            if (validator != null) {
                this.validationError = validator.getValidationMessage();
                this.isValidated = false;
                this.isChangeValidated = false;
            } else {
                this.validationError = "This is fine";
                this.isValidated = true;
                this.isChangeValidated = true;
            }
        }
    }
}

