/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.serverorder.OrderSummary;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.module.serverorder.screen.OrderServerScreen;
import net.creeperhost.polylib.client.screen.ScreenHelper;
import net.creeperhost.polylib.client.screen.widget.ScreenWell;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class QuoteScreen
extends OrderServerScreen {
    public OrderSummary summary;
    private ScreenWell wellLeft;
    private ScreenWell wellRight;
    private ScreenWell wellBottom;
    private boolean refreshing;
    private int ticks;

    public QuoteScreen(int stepId, Order order) {
        super(stepId, order);
    }

    @Override
    public void m_7856_() {
        this.m_169413_();
        int start = this.f_96543_ / 2 + 10;
        int end = this.f_96543_;
        int middle = (end - start) / 2;
        super.m_7856_();
        this.wellLeft = new ScreenWell(this.f_96541_, this.f_96543_ / 2 - 10, 67, this.f_96544_ - 88, I18n.m_118938_((String)"minetogether.quote.vpsfeatures", (Object[])new Object[0]), new ArrayList(), true, 0);
        this.wellRight = new ScreenWell(this.f_96541_, this.f_96543_, 67, this.f_96544_ - 88, I18n.m_118938_((String)"minetogether.quote.vpsincluded", (Object[])new Object[0]), new ArrayList(), true, this.f_96543_ / 2 + 10);
        this.wellBottom = new ScreenWell(this.f_96541_, this.f_96543_, this.f_96544_ - 83, this.f_96544_ - 36, "", new ArrayList(), true, 0);
        String name = ServerOrderCallbacks.getCountries().get(this.order.country);
        if (name == null || name.isEmpty()) {
            name = "Failed to load";
        }
        if (this.summary == null && !this.refreshing) {
            this.updateSummary();
        }
        this.buttonNext.m_93666_((Component)new TranslatableComponent("minetogether.button.order"));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(1);
        QuoteScreen.m_93172_((PoseStack)poseStack, (int)0, (int)(this.f_96544_ - 20), (int)this.f_96543_, (int)20, (int)-1728053248);
        if (!this.refreshing) {
            if (!this.summary.summaryError.isEmpty()) {
                super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                QuoteScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"quote.error", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)50, (int)-1);
                QuoteScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)this.summary.summaryError, (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)60, (int)-1);
                return;
            }
            this.wellBottom.render(poseStack);
            this.wellLeft.render(poseStack);
            this.wellRight.render(poseStack);
            QuoteScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(I18n.m_118938_((String)"minetogether.quote.requirements", (Object[])new Object[0]) + " " + this.summary.serverHostName.toLowerCase() + " package"), (int)(this.f_96543_ / 2), (int)50, (int)-1);
            String formatString = this.summary.prefix + "%1$.2f " + this.summary.suffix;
            String subTotalString = I18n.m_118938_((String)"minetogether.quote.subtotal", (Object[])new Object[0]) + ":  ";
            int subTotalWidth = this.f_96547_.m_92895_(subTotalString);
            String discountString = I18n.m_118938_((String)"minetogether.quote.discount", (Object[])new Object[0]) + ":  ";
            int discountWidth = this.f_96547_.m_92895_(discountString);
            String taxString = I18n.m_118938_((String)"minetogether.quote.tax", (Object[])new Object[0]) + ":  ";
            int taxWidth = this.f_96547_.m_92895_(taxString);
            String totalString = I18n.m_118938_((String)"minetogether.quote.total", (Object[])new Object[0]) + ":  ";
            int totalWidth = this.f_96547_.m_92895_(totalString);
            int headerSize = Math.max(subTotalWidth, Math.max(taxWidth, Math.max(totalWidth, discountWidth)));
            int subTotalValueWidth = this.f_96547_.m_92895_(String.format(formatString, this.summary.subTotal));
            int discountValueWidth = this.f_96547_.m_92895_(String.format(formatString, this.summary.discount));
            int taxValueWidth = this.f_96547_.m_92895_(String.format(formatString, this.summary.tax));
            int totalValueWidth = this.f_96547_.m_92895_(String.format(formatString, this.summary.tax));
            int maxStringSize = headerSize + Math.max(subTotalValueWidth, Math.max(discountValueWidth, Math.max(taxValueWidth, totalValueWidth)));
            int offset = maxStringSize / 2;
            int otherOffset = (this.f_96543_ / 2 - 10) / 2 - offset;
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)subTotalString, (int)otherOffset, (int)(this.f_96544_ - 80), (int)0xFFFFFF);
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)String.format(formatString, this.summary.preDiscount), (int)(otherOffset + headerSize), (int)(this.f_96544_ - 80), (int)0xFFFFFF);
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)discountString, (int)otherOffset, (int)(this.f_96544_ - 70), (int)0xFFFFFF);
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)String.format(formatString, this.summary.discount), (int)(otherOffset + headerSize), (int)(this.f_96544_ - 70), (int)0xFFFFFF);
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)taxString, (int)otherOffset, (int)(this.f_96544_ - 60), (int)0xFFFFFF);
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)String.format(formatString, this.summary.tax), (int)(otherOffset + headerSize), (int)(this.f_96544_ - 60), (int)0xFFFFFF);
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)totalString, (int)otherOffset, (int)(this.f_96544_ - 50), (int)0xFFFFFF);
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)String.format(formatString, this.summary.total), (int)(otherOffset + headerSize), (int)(this.f_96544_ - 50), (int)0xFFFFFF);
            int start = this.f_96543_ / 2 + 10;
            int end = this.f_96543_;
            int middle = (end - start) / 2;
            int stringStart = this.f_96547_.m_92895_(I18n.m_118938_((String)"minetogether.quote.figures", (Object[])new Object[0])) / 2;
            QuoteScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.quote.figures", (Object[])new Object[0]), (int)(start + middle - stringStart), (int)(this.f_96544_ - 80), (int)0xFFFFFF);
            QuoteScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)(ChatFormatting.BOLD + I18n.m_118938_((String)ServerOrderCallbacks.getCountries().get(this.order.country), (Object[])new Object[0])), (int)(start + middle), (int)(this.f_96544_ - 65), (int)0xFFFFFF);
        } else {
            QuoteScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.quote.refreshing", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)50, (int)-1);
            ScreenHelper.loadingSpin((PoseStack)poseStack, (float)partialTicks, (int)this.ticks, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (ItemStack)new ItemStack((ItemLike)Items.f_42579_));
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void m_96624_() {
        ++this.ticks;
        super.m_96624_();
    }

    @Override
    public String getStepName() {
        return I18n.m_118938_((String)"minetogether.order.screen.generalinfo.quote", (Object[])new Object[0]);
    }

    private void updateSummary() {
        this.refreshing = true;
        this.summary = null;
        Order order = this.order;
        CompletableFuture.runAsync(() -> {
            this.summary = ServerOrderCallbacks.getSummary(order, Config.getInstance().getVersion(), Config.getInstance().getPromo());
            order.productID = this.summary.productID;
            order.currency = this.summary.currency;
            this.wellLeft.lines = this.summary.serverFeatures;
            this.wellRight.lines = this.summary.serverIncluded;
            this.refreshing = false;
        });
    }
}

