/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.serverorder.DefferedValidation;
import net.creeperhost.minetogether.lib.serverorder.IOrderValidation;
import net.creeperhost.minetogether.lib.serverorder.RegexValidator;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.module.serverorder.screen.OrderServerScreen;
import net.creeperhost.minetogether.module.serverorder.screen.listentries.ListEntryCountry;
import net.creeperhost.minetogether.module.serverorder.widget.TextFieldDetails;
import net.creeperhost.polylib.client.screen.widget.ScreenList;
import net.creeperhost.polylib.client.screen.widget.ScreenListEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;

public class PersonalDetailsScreen
extends OrderServerScreen {
    public List<TextFieldDetails> fields = null;
    public TextFieldDetails focusedField;
    public boolean isEmailValid = false;
    private boolean loginMode;
    private Button loginButton;
    private boolean loggingIn;
    private String loggingInError = "";
    private boolean loggedIn;
    private boolean isSure;
    private boolean orderPressed;
    private Component info2 = null;
    private String prevLoginString;
    private boolean prevLoginVisible;
    private boolean prevLoginEnabled;
    private boolean renderList = false;
    private boolean first = false;
    private ScreenList list;
    private Button selectCountry;
    private Button buttonList;
    private EditBox searchEntry;

    public PersonalDetailsScreen(int stepId, Order order) {
        super(stepId, order);
        order.clientID = "";
    }

    @Override
    public String getStepName() {
        return I18n.m_118938_((String)"minetogether.screen.personal_details", (Object[])new Object[0]);
    }

    @Override
    public void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        this.list = new ScreenList((Screen)this, this.f_96541_, this.f_96543_, this.f_96544_, 56, this.f_96544_ - 36, 36);
        this.m_7787_((GuiEventListener)this.list);
        this.searchEntry = new EditBox(this.f_96547_, this.f_96543_ / 2 - 80, this.f_96544_ - 32, 160, 20, (Component)new TranslatableComponent(""));
        this.m_7787_((GuiEventListener)this.searchEntry);
        this.updateList();
        this.loginButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 10, 80, 20, (Component)new TranslatableComponent("minetogether.button.login"), p -> {
            if (this.orderPressed && !this.isSure) {
                this.isSure = true;
                this.buttonNext.m_5691_();
                return;
            }
            this.loggingIn = true;
            this.loginButton.f_93623_ = false;
            this.loginButton.m_93666_((Component)new TranslatableComponent("minetogether.button.logging"));
            CompletableFuture.runAsync(() -> {
                String result = ServerOrderCallbacks.doLogin(this.order.emailAddress, this.order.password);
                String[] resultSplit = result.split(":");
                if (resultSplit[0].equals("success")) {
                    this.order.currency = resultSplit[1] != null ? resultSplit[1] : "1";
                    this.order.clientID = resultSplit[2] != null ? resultSplit[2] : "98874";
                    this.loggingIn = false;
                    this.loggedIn = true;
                    this.loggingInError = "";
                    this.loginButton.m_93666_((Component)new TranslatableComponent("minetogether.button.done"));
                } else {
                    this.loggingIn = false;
                    this.loggedIn = false;
                    this.loggingInError = result;
                    this.loginButton.f_93623_ = true;
                    this.loginButton.m_93666_((Component)new TranslatableComponent("minetogether.button.logintryagain"));
                }
            });
        }));
        this.loginButton.f_93624_ = this.loginMode;
        if (this.orderPressed && !this.isSure) {
            this.loginButton.m_93666_((Component)new TranslatableComponent("button.order"));
            this.loginButton.f_93623_ = true;
            this.loginButton.f_93624_ = true;
            this.buttonNext.f_93624_ = false;
        } else if (this.loggingIn) {
            this.loginButton.m_93666_((Component)new TranslatableComponent("button.logging"));
            this.loginButton.f_93623_ = false;
        } else if (this.loggedIn) {
            this.loginButton.m_93666_((Component)new TranslatableComponent("button.done"));
            this.loginButton.f_93623_ = false;
        } else if (!this.loggingInError.isEmpty()) {
            this.loginButton.m_93666_((Component)new TranslatableComponent("button.logintryagain"));
        }
        this.fields = new ArrayList<TextFieldDetails>();
        int x = this.f_96543_ / 2;
        int fieldWidths = 185;
        ArrayList<IOrderValidation> defaultValidators = new ArrayList<IOrderValidation>();
        defaultValidators.add(new IOrderValidation(){

            @Override
            public boolean validationCheckAtPhase(IOrderValidation.ValidationPhase phase) {
                return phase.equals((Object)IOrderValidation.ValidationPhase.CHANGED);
            }

            @Override
            public boolean isValid(String string) {
                return !string.isEmpty();
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            public String getValidationMessage() {
                return "Cannot be blank";
            }

            @Override
            public String getName() {
                return "NotBlankValidator";
            }
        });
        ArrayList<IOrderValidation> emailValidators = new ArrayList<IOrderValidation>(defaultValidators);
        emailValidators.add(new RegexValidator("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", "Invalid email address"));
        emailValidators.add(new DefferedValidation(){

            @Override
            public boolean validationCheckAtPhase(IOrderValidation.ValidationPhase phase) {
                return phase.equals((Object)IOrderValidation.ValidationPhase.FOCUSLOST);
            }

            @Override
            public boolean isValidReal(String string) {
                return ServerOrderCallbacks.doesEmailExist(string);
            }

            @Override
            public String getMessageReal() {
                return "Email already exists";
            }

            @Override
            public String getName() {
                return "NotEmailExistsValidator";
            }
        });
        this.fields.add(new TextFieldDetails(this, 0, I18n.m_118938_((String)"minetogether.info.e_mail", (Object[])new Object[0]), this.order.emailAddress, x - 205, 45, fieldWidths, 20, emailValidators));
        this.fields.add(new TextFieldDetails(this, 1, I18n.m_118938_((String)"minetogether.info.password", (Object[])new Object[0]), this.order.password, x + 5, 45, fieldWidths, 20, defaultValidators, "*"));
        this.fields.add(new TextFieldDetails(this, 2, I18n.m_118938_((String)"minetogether.info.first_name", (Object[])new Object[0]), this.order.firstName, x - 205, 75, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 3, I18n.m_118938_((String)"minetogether.info.last_name", (Object[])new Object[0]), this.order.lastName, x + 5, 75, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 4, I18n.m_118938_((String)"minetogether.info.address", (Object[])new Object[0]), this.order.address, x - 205, 105, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 5, I18n.m_118938_((String)"minetogether.info.city", (Object[])new Object[0]), this.order.city, x + 5, 105, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 6, I18n.m_118938_((String)"minetogether.info.zip", (Object[])new Object[0]), this.order.zip, x - 205, 135, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 7, I18n.m_118938_((String)"minetogether.info.state", (Object[])new Object[0]), this.order.state, x + 5, 135, fieldWidths, 20, defaultValidators));
        String buttonName = ServerOrderCallbacks.getCountries().get(this.order.country);
        if (buttonName == null || buttonName.isEmpty()) {
            buttonName = "Invalid";
        }
        this.buttonList = new Button(x - 205, 165, fieldWidths, 20, (Component)new TranslatableComponent(buttonName), p -> {
            this.renderList = true;
        });
        this.m_142416_((GuiEventListener)this.buttonList);
        this.selectCountry = new Button(this.f_96543_ - 90, this.f_96544_ - 30, 80, 20, (Component)new TranslatableComponent("minetogether.button.select"), button -> {
            this.renderList = false;
            ListEntryCountry listEntryCountry = (ListEntryCountry)this.list.getCurrSelected();
            this.order.country = listEntryCountry.countryID;
            this.buttonList.m_93666_((Component)new TranslatableComponent(ServerOrderCallbacks.getCountries().get(listEntryCountry.countryID)));
        });
        this.m_142416_((GuiEventListener)this.selectCountry);
        this.fields.add(new TextFieldDetails(this, 9, I18n.m_118938_((String)"minetogether.info.phone", (Object[])new Object[0]), this.order.phone, x + 5, 165, fieldWidths, 20, defaultValidators));
        String info2Text = I18n.m_118938_((String)"minetogether.order.info2", (Object[])new Object[0]);
        String regex = "\\((.*?)\\|(.*?)\\)";
        Pattern pattern = Pattern.compile("\\((.*?)\\|(.*?)\\)");
        Matcher matcher = pattern.matcher(info2Text);
        int lastEnd = 0;
        TranslatableComponent component = null;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String part = info2Text.substring(lastEnd, start);
            if (part.length() > 0) {
                if (component == null) {
                    component = new TranslatableComponent(part);
                } else {
                    component.m_6881_().m_7220_((Component)new TranslatableComponent(part));
                }
            }
            lastEnd = end;
            TranslatableComponent link = new TranslatableComponent(matcher.group(1));
            Style style = link.m_7383_();
            style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, matcher.group(2)));
            style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE));
            style.m_131162_(Boolean.valueOf(true));
            style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent(I18n.m_118938_((String)"order.url", (Object[])new Object[0]))));
            if (component == null) {
                component = link;
                continue;
            }
            component.m_6881_().m_7220_((Component)new TranslatableComponent(link.getString()));
        }
        this.info2 = component;
    }

    public void m_96624_() {
        super.m_96624_();
        this.selectCountry.f_93623_ = this.renderList;
        this.selectCountry.f_93624_ = this.renderList;
        this.buttonCancel.f_93623_ = !this.renderList;
        this.buttonCancel.f_93624_ = !this.renderList;
        this.buttonPrev.f_93623_ = !this.renderList;
        this.buttonPrev.f_93624_ = !this.renderList;
        this.buttonList.f_93623_ = !this.renderList && !this.loginMode;
        this.buttonList.f_93624_ = !this.renderList && !this.loginMode;
        this.buttonNext.f_93623_ = !this.renderList;
        this.buttonNext.f_93624_ = !this.renderList;
        this.buttonNext.f_93623_ = true;
        boolean bl = this.loginButton.f_93624_ = this.loginMode || this.orderPressed && !this.isSure;
        if (this.loggedIn) {
            this.f_96541_.m_91152_(PersonalDetailsScreen.getByStep(this.stepId + 1, this.order, null));
        }
        for (TextFieldDetails field : this.fields) {
            field.checkPendingValidations();
            field.m_94120_();
            if (field.isValidated) continue;
            this.buttonNext.f_93623_ = false;
        }
        this.buttonNext.f_93623_ = this.buttonNext.f_93623_ && this.isEmailValid;
        this.buttonNext.f_93623_ = this.loggedIn || this.buttonNext.f_93623_;
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        PersonalDetailsScreen.m_93172_((PoseStack)matrixStack, (int)0, (int)(this.f_96544_ - 20), (int)this.f_96543_, (int)20, (int)-1728053248);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.renderList) {
            this.list.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.searchEntry.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            if (!(this.orderPressed && this.isSure || this.loginMode)) {
                PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"No data will be sent until you complete the order.", (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 45), (int)0xFFFFFF);
            }
            if (!this.orderPressed || this.isSure) {
                for (TextFieldDetails field : this.fields) {
                    if (this.loginMode) {
                        if (field.getId() >= 2) continue;
                        field.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                        continue;
                    }
                    field.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                }
                if (this.loginMode) {
                    if (this.loggingIn) {
                        PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.details.login", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 20), (int)0xFFFFFF);
                    } else if (!this.loggingInError.isEmpty()) {
                        PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)(I18n.m_118938_((String)"minetogether.details.loginerror", (Object[])new Object[0]) + this.loggingInError), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 20), (int)0xFFFFFF);
                    } else if (this.loggedIn) {
                        PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.details.loginsuccess", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 20), (int)0xFFFFFF);
                    } else {
                        PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.details.accountexists", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 20), (int)0xFFFFFF);
                    }
                }
            } else {
                int info2Start = this.f_96544_ / 2 - 50;
                PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"order.info1", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 60), (int)0xFFFFFF);
                PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.info2.getString(), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 50), (int)0xFFFFFF);
                PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"order.info3", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 30), (int)0xFFFFFF);
                PersonalDetailsScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"order.info4", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 20), (int)0xFFFFFF);
                if (mouseY >= info2Start) {
                    HoverEvent event;
                    Component component;
                    Objects.requireNonNull(this.f_96547_);
                    if (mouseY <= info2Start + 9 && (component = this.getComponent(mouseX, mouseY)) != null && (event = component.m_7383_().m_131186_()) != null && event.m_130820_() == HoverEvent.Action.f_130831_) {
                        this.m_96602_(matrixStack, (Component)new TranslatableComponent(event.toString()), mouseX, mouseY);
                    }
                }
            }
        }
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (this.searchEntry.m_93696_()) {
            boolean flag = this.searchEntry.m_5534_(typedChar, keyCode);
            this.updateList();
            return flag;
        }
        TextFieldDetails field = this.focusedField;
        if (this.focusedField == null) {
            return false;
        }
        if (field.m_5534_(typedChar, keyCode)) {
            int id = field.getId();
            String text = field.m_94155_().trim();
            switch (id) {
                case 0: {
                    this.order.emailAddress = text;
                    break;
                }
                case 1: {
                    this.order.password = text;
                    break;
                }
                case 2: {
                    this.order.firstName = text;
                    break;
                }
                case 3: {
                    this.order.lastName = text;
                    break;
                }
                case 4: {
                    this.order.address = text;
                    break;
                }
                case 5: {
                    this.order.city = text;
                    break;
                }
                case 6: {
                    this.order.zip = text;
                    break;
                }
                case 7: {
                    this.order.state = text;
                    break;
                }
                case 8: {
                    this.order.country = text;
                    break;
                }
                case 9: {
                    this.order.phone = text;
                }
            }
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.searchEntry.m_93696_()) {
            boolean flag = this.searchEntry.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
            this.updateList();
            return flag;
        }
        if (this.focusedField != null) {
            if (this.focusedField.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
                int id = this.focusedField.getId();
                String text = this.focusedField.m_94155_().trim();
                switch (id) {
                    case 0: {
                        this.order.emailAddress = text;
                        break;
                    }
                    case 1: {
                        this.order.password = text;
                        break;
                    }
                    case 2: {
                        this.order.firstName = text;
                        break;
                    }
                    case 3: {
                        this.order.lastName = text;
                        break;
                    }
                    case 4: {
                        this.order.address = text;
                        break;
                    }
                    case 5: {
                        this.order.city = text;
                        break;
                    }
                    case 6: {
                        this.order.zip = text;
                        break;
                    }
                    case 7: {
                        this.order.state = text;
                        break;
                    }
                    case 8: {
                        this.order.country = text;
                        break;
                    }
                    case 9: {
                        this.order.phone = text;
                    }
                }
                return true;
            }
            if (p_keyPressed_1_ == 258) {
                TextFieldDetails field = this.focusedField;
                int adjustAm = 1;
                int fieldsSize = this.fields.size();
                field.m_93692_(false);
                int newField = (field.getId() + adjustAm) % fieldsSize;
                if (newField == -1) {
                    newField = fieldsSize - 1;
                }
                TextFieldDetails newF = null;
                while (newF == null) {
                    TextFieldDetails tempField = this.fields.get(newField);
                    if (tempField.canBeFocused()) {
                        newF = tempField;
                        continue;
                    }
                    if ((newField = (newField + adjustAm) % fieldsSize) != -1) continue;
                    newField = fieldsSize - 1;
                }
                newF.m_93692_(true);
            }
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.buttonList != null && this.buttonList.m_5953_(mouseX, mouseY)) {
            return this.buttonList.m_6375_(mouseX, mouseY, mouseButton);
        }
        super.m_6375_(mouseX, mouseY, mouseButton);
        int info2Start = this.f_96544_ / 2 - 50;
        if (this.orderPressed && !this.isSure && mouseY >= (double)info2Start) {
            Component comp;
            ClickEvent clickevent;
            Objects.requireNonNull(this.f_96547_);
            if (mouseY <= (double)(info2Start + 9) && (clickevent = (comp = this.getComponent(mouseX, mouseY)).m_7383_().m_131182_()) != null && clickevent.m_130622_() == ClickEvent.Action.OPEN_URL) {
                try {
                    URI uri = new URI(clickevent.m_130623_());
                    Class<?> oclass = Class.forName("java.awt.Desktop");
                    Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    oclass.getMethod("browse", URI.class).invoke(object, uri);
                    return true;
                }
                catch (Throwable t) {
                    MineTogetherCommon.logger.error("Can't open url for " + clickevent, t);
                    return false;
                }
            }
        }
        for (TextFieldDetails field : this.fields) {
            if (!field.m_6375_(mouseX, mouseY, mouseButton)) continue;
            if (this.focusedField != null) {
                this.focusedField.m_93692_(false);
            }
            this.focusedField = field;
            field.m_93692_(true);
            return true;
        }
        return false;
    }

    private Component getComponent(double mouseX, double mouseY) {
        int stringWidth = this.f_96547_.m_92895_(this.info2.getString());
        int begin = this.f_96543_ / 2 - stringWidth / 2;
        if (this.info2 instanceof TranslatableComponent) {
            TranslatableComponent comp = (TranslatableComponent)this.info2;
            int prevWidth = begin;
            for (Component inner : comp.m_7360_()) {
                StringBuilder stringbuilder = new StringBuilder();
                String s = inner.getString();
                if (!s.isEmpty()) {
                    stringbuilder.append(inner.m_7383_());
                    stringbuilder.append(s);
                    stringbuilder.append(ChatFormatting.RESET);
                }
                int width = this.f_96547_.m_92895_(stringbuilder.toString());
                if (mouseX >= (double)prevWidth && mouseX <= (double)(prevWidth + width)) {
                    return inner;
                }
                prevWidth += width;
            }
        }
        return null;
    }

    public void validationChanged(TextFieldDetails details, boolean valid, IOrderValidation validator, IOrderValidation.ValidationPhase phase) {
        if (details.getId() == 0) {
            if (!valid && validator.getName().equals("NotEmailExistsValidator") && !validator.isAsync()) {
                this.isEmailValid = false;
                this.loginMode = true;
            } else {
                this.loginMode = false;
                this.isEmailValid = phase.equals((Object)IOrderValidation.ValidationPhase.FOCUSLOST);
            }
        }
    }

    public void validationChangedDeferred(TextFieldDetails textFieldDetails, DefferedValidation pendingValidation) {
        if (!pendingValidation.isValid("")) {
            this.validationChanged(textFieldDetails, false, pendingValidation, pendingValidation.getPhase());
        } else {
            this.validationChanged(textFieldDetails, true, null, pendingValidation.getPhase());
        }
    }

    public void updateList() {
        this.first = false;
        this.list.clearList();
        Map<String, String> locations = ServerOrderCallbacks.getCountries();
        for (Map.Entry<String, String> entry : locations.entrySet()) {
            if (!this.searchEntry.m_94155_().isEmpty() && !entry.getValue().toLowerCase().contains(this.searchEntry.m_94155_().toLowerCase())) continue;
            ListEntryCountry listEntry = new ListEntryCountry(this.list, entry.getKey(), entry.getValue());
            this.list.add((ScreenListEntry)listEntry);
            if (!this.order.country.equals(listEntry.countryID)) continue;
            this.list.m_6987_((AbstractSelectionList.Entry)listEntry);
        }
    }
}

