/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.serverorder.AvailableResult;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.module.serverorder.screen.OrderServerScreen;
import net.creeperhost.polylib.client.screen.widget.TextFieldValidate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class GeneralServerInfoScreen
extends OrderServerScreen {
    private static final ResourceLocation lockIcon = new ResourceLocation("minetogether", "textures/lock.png");
    private static final Random random = new Random();
    private String message = "Name can not be blank";
    private EditBox nameField;
    private boolean isAcceptable = false;
    private boolean nameChecked = false;
    private long lastKeyTyped;
    private Screen parent;

    public GeneralServerInfoScreen(int stepId, Order order, Screen parent) {
        super(stepId, order);
        this.parent = parent;
    }

    @Override
    public void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        int halfWidth = this.f_96543_ / 2;
        int halfHeight = this.f_96544_ / 2;
        int checkboxWidth = this.f_96547_.m_92895_(I18n.m_118938_((String)"minetogether.screen.generalinfo.pregen", (Object[])new Object[0])) + 13;
        this.nameField = new TextFieldValidate(this.f_96547_, halfWidth - 100, halfHeight - 50, 200, 20, "([A-Za-z0-9]*)", "");
        this.m_142416_((GuiEventListener)this.nameField);
        this.m_142416_((GuiEventListener)new Checkbox(halfWidth - checkboxWidth / 2, halfHeight - 8, 20, 20, (Component)new TranslatableComponent("minetogether.screen.generalinfo.pregen"), this.order.pregen));
        this.nameField.m_94199_(16);
        this.nameField.m_94144_(this.order.name.isEmpty() ? GeneralServerInfoScreen.getDefaultName() : this.order.name);
        this.order.name = this.nameField.m_94155_().trim();
        this.addButtons();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_96626_(1);
        GeneralServerInfoScreen.m_93172_((PoseStack)poseStack, (int)0, (int)(this.f_96544_ - 20), (int)this.f_96543_, (int)20, (int)-1728053248);
        GeneralServerInfoScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"minetogether.info.server_name", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 65), (int)-1);
        RenderSystem.m_157456_((int)0, (ResourceLocation)lockIcon);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GeneralServerInfoScreen.m_93133_((PoseStack)poseStack, (int)(this.f_96543_ / 2 - 8), (int)(this.f_96544_ / 2 + 40), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        int strStart = 61;
        GeneralServerInfoScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether.screen.generalinfo.secure.line1"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + strStart), (int)0xFFFFFF);
        GeneralServerInfoScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether.screen.generalinfo.secure.line2"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + strStart + 10), (int)0xFFFFFF);
        GeneralServerInfoScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether.screen.generalinfo.secure.line3"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + strStart + 20), (int)0xFFFFFF);
        this.nameField.m_6305_(poseStack, i, j, f);
        int colour = this.nameChecked && this.isAcceptable ? 65280 : 0xFF0000;
        GeneralServerInfoScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.message, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 26), (int)colour);
        super.m_6305_(poseStack, i, j, f);
    }

    public void m_96624_() {
        super.m_96624_();
        this.validateName();
    }

    public void validateName() {
        String nameToCheck = this.nameField.m_94155_().trim();
        boolean isEmpty = nameToCheck.isEmpty();
        if (this.lastKeyTyped + 400L < System.currentTimeMillis() && !this.nameChecked) {
            this.nameChecked = true;
            if (isEmpty) {
                this.message = "Name cannot be blank";
                this.isAcceptable = false;
            } else {
                CompletableFuture.runAsync(() -> {
                    AvailableResult result = ServerOrderCallbacks.getNameAvailable(nameToCheck);
                    this.isAcceptable = result.getSuccess();
                    this.message = result.getMessage();
                });
            }
        }
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        String nameFieldOldValue = this.nameField.m_94155_();
        if (!this.nameField.m_5534_(typedChar, keyCode)) {
            super.m_5534_(typedChar, keyCode);
        } else if (!nameFieldOldValue.equals(this.nameField.m_94155_())) {
            this.nameChecked = false;
            this.message = "Name not yet checked";
            this.order.name = this.nameField.m_94155_().trim();
            this.lastKeyTyped = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public static String getDefaultName() {
        String[] nm1 = new String[]{"amber", "angel", "spirit", "basin", "lagoon", "basin", "arrow", "autumn", "bare", "bay", "beach", "bear", "bell", "black", "bleak", "blind", "bone", "boulder", "bridge", "brine", "brittle", "bronze", "castle", "cave", "chill", "clay", "clear", "cliff", "cloud", "cold", "crag", "crow", "crystal", "curse", "dark", "dawn", "dead", "deep", "deer", "demon", "dew", "dim", "dire", "dirt", "dog", "dragon", "dry", "dusk", "dust", "eagle", "earth", "east", "ebon", "edge", "elder", "ember", "ever", "fair", "fall", "false", "far", "fay", "fear", "flame", "flat", "frey", "frost", "ghost", "glimmer", "gloom", "gold", "grass", "gray", "green", "grim", "grime", "hazel", "heart", "high", "hollow", "honey", "hound", "ice", "iron", "kil", "knight", "lake", "last", "light", "lime", "little", "lost", "mad", "mage", "maple", "mid", "might", "mill", "mist", "moon", "moss", "mud", "mute", "myth", "never", "new", "night", "north", "oaken", "ocean", "old", "ox", "pearl", "pine", "pond", "pure", "quick", "rage", "raven", "red", "rime", "river", "rock", "rogue", "rose", "rust", "salt", "sand", "scorch", "shade", "shadow", "shimmer", "shroud", "silent", "silk", "silver", "sleek", "sleet", "sly", "small", "smooth", "snake", "snow", "south", "spring", "stag", "star", "steam", "steel", "steep", "still", "stone", "storm", "summer", "sun", "swamp", "swan", "swift", "thorn", "timber", "trade", "west", "whale", "whit", "white", "wild", "wilde", "wind", "winter", "wolf"};
        String[] nm2 = new String[]{"acre", "band", "barrow", "bay", "bell", "born", "borough", "bourne", "breach", "break", "brook", "burgh", "burn", "bury", "cairn", "call", "chill", "cliff", "coast", "crest", "cross", "dale", "denn", "drift", "fair", "fall", "falls", "fell", "field", "ford", "forest", "fort", "front", "frost", "garde", "gate", "glen", "grasp", "grave", "grove", "guard", "gulch", "gulf", "hall", "hallow", "ham", "hand", "harbor", "haven", "helm", "hill", "hold", "holde", "hollow", "horn", "host", "keep", "land", "light", "maw", "meadow", "mere", "mire", "mond", "moor", "more", "mount", "mouth", "pass", "peak", "point", "pond", "port", "post", "reach", "rest", "rock", "run", "scar", "shade", "shear", "shell", "shield", "shore", "shire", "side", "spell", "spire", "stall", "wich", "minster", "star", "storm", "strand", "summit", "tide", "town", "vale", "valley", "vault", "vein", "view", "ville", "wall", "wallow", "ward", "watch", "water", "well", "wharf", "wick", "wind", "wood", "yard"};
        int rnd = random.nextInt(nm1.length);
        int rnd2 = random.nextInt(nm2.length);
        while (nm1[rnd] == nm2[rnd2]) {
            rnd2 = random.nextInt(nm2.length);
        }
        return nm1[rnd] + nm2[rnd2] + random.nextInt(999);
    }

    public void addButtons() {
    }

    @Override
    public String getStepName() {
        return I18n.m_118938_((String)"minetogether.order.screen.generalinfo", (Object[])new Object[0]);
    }
}

