/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.multiplayer.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.serverlists.Server;
import net.creeperhost.minetogether.lib.serverlists.ServerListCallbacks;
import net.creeperhost.minetogether.module.multiplayer.data.PublicServerEntry;
import net.creeperhost.minetogether.module.multiplayer.data.ServerDataPublic;
import net.creeperhost.minetogether.module.multiplayer.data.ServerListType;
import net.creeperhost.minetogether.module.multiplayer.data.ServerSortOrder;
import net.creeperhost.minetogether.module.multiplayer.screen.ServerTypeScreen;
import net.creeperhost.minetogether.module.multiplayer.sort.LocationComparator;
import net.creeperhost.minetogether.module.multiplayer.sort.PingComparator;
import net.creeperhost.minetogether.module.multiplayer.sort.PlayerComparator;
import net.creeperhost.minetogether.module.multiplayer.sort.ServerNameComparator;
import net.creeperhost.minetogether.module.multiplayer.sort.UptimeComparator;
import net.creeperhost.polylib.client.screen.ButtonHelper;
import net.creeperhost.polylib.client.screen.ScreenHelper;
import net.creeperhost.polylib.client.screen.widget.buttons.DropdownButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class JoinMultiplayerScreenPublic
extends JoinMultiplayerScreen {
    private final Screen parent;
    private ServerListType serverListType;
    public ServerSortOrder sortOrder = ServerSortOrder.RANDOM;
    private DropdownButton<ServerSortOrder> dropdownButton;
    private boolean loadingSevers = false;
    private int ticks;
    private AbstractWidget editButton;
    private AbstractWidget deleteButton;
    private AbstractWidget cancelButton;

    public JoinMultiplayerScreenPublic(Screen parent, ServerListType serverListType, ServerSortOrder serverSortOrder) {
        super(parent);
        this.parent = parent;
        this.serverListType = serverListType;
        this.sortOrder = serverSortOrder;
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.f_99673_.m_6702_().clear();
        this.updateServerList();
        this.sort();
        this.addButtons();
    }

    public void updateServerList() {
        this.loadingSevers = true;
        ServerList serverList = new ServerList(Minecraft.m_91087_());
        if (serverList.m_105445_() > 0) {
            for (int i = 0; i < serverList.m_105445_(); ++i) {
                ServerData serverData = serverList.m_105432_(i);
                serverList.m_105440_(serverData);
            }
        }
        List<Server> list = null;
        try {
            list = ServerListCallbacks.getServerList(this.serverListType, MineTogetherClient.getUUID(), MineTogetherCommon.base64, Config.getInstance().getCurseProjectID());
        }
        catch (IOException e) {
            Sentry.captureException(e);
        }
        if (list != null && !list.isEmpty()) {
            for (Server server : list) {
                serverList.m_105443_((ServerData)new ServerDataPublic(server));
            }
            this.updateServers(serverList);
        }
        this.loadingSevers = false;
    }

    public void updateServers(ServerList serverList) {
        this.f_99673_.m_6702_().clear();
        for (int i = 0; i < serverList.m_105445_(); ++i) {
            this.f_99673_.m_6702_().add(new PublicServerEntry(this, this.f_99673_, serverList.m_105432_(i)));
        }
    }

    public void addButtons() {
        Button addServer;
        String buttonName = "minetogether.multiplayer.title.prefix." + this.serverListType.name().toLowerCase();
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 85, 5, 80, 20, (Component)new TranslatableComponent(buttonName), p -> this.f_96541_.m_91152_((Screen)new ServerTypeScreen((Screen)this))));
        this.dropdownButton = new DropdownButton(this.f_96543_ - 165, 5, 80, 20, (Component)new TranslatableComponent("minetogether.multiplayer.sort"), (DropdownButton.IDropdownOption)this.sortOrder, false, p -> {
            if (this.sortOrder != this.dropdownButton.getSelected()) {
                this.sortOrder = (ServerSortOrder)this.dropdownButton.getSelected();
                this.sort();
                this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreenPublic(this.parent, this.serverListType, this.sortOrder));
            }
        });
        this.m_142416_((GuiEventListener)this.dropdownButton);
        try {
            this.dropdownButton.setSelected((DropdownButton.IDropdownOption)this.sortOrder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editButton = ButtonHelper.findButton((String)"selectServer.edit", (Screen)this);
        this.deleteButton = ButtonHelper.findButton((String)"selectServer.delete", (Screen)this);
        this.cancelButton = ButtonHelper.removeButton((String)"gui.cancel", (Screen)this);
        if (this.cancelButton != null) {
            this.m_142416_((GuiEventListener)new Button(this.cancelButton.f_93620_, this.cancelButton.f_93621_, this.cancelButton.m_5711_(), this.cancelButton.m_93694_(), this.cancelButton.m_6035_(), button -> this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()))));
        }
        if ((addServer = ButtonHelper.findButton((String)"selectServer.add", (Screen)this)) != null) {
            addServer.f_93623_ = false;
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 80, this.f_96544_ - 52, 75, 20, (Component)new TranslatableComponent("selectServer.refresh"), p -> Minecraft.m_91087_().m_91152_((Screen)new JoinMultiplayerScreenPublic((Screen)new TitleScreen(), this.serverListType, this.sortOrder))));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(1);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.loadingSevers) {
            ScreenHelper.loadingSpin((PoseStack)poseStack, (float)partialTicks, (int)this.ticks, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (ItemStack)new ItemStack((ItemLike)Items.f_42579_));
        }
    }

    public void m_99730_() {
        super.m_99730_();
        if (this.editButton != null) {
            this.editButton.f_93623_ = false;
        }
        if (this.deleteButton != null) {
            this.deleteButton.f_93623_ = false;
        }
    }

    public void m_96624_() {
        ++this.ticks;
    }

    public void m_99729_() {
        ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.f_99673_.m_93511_();
        if (entry != null && entry instanceof PublicServerEntry) {
            this.join(((PublicServerEntry)entry).getServerData());
            return;
        }
        super.m_99729_();
    }

    public void join(ServerData serverData) {
        ConnectScreen.m_169267_((Screen)new JoinMultiplayerScreen((Screen)this), (Minecraft)Minecraft.m_91087_(), (ServerAddress)ServerAddress.m_171864_((String)serverData.f_105363_), (ServerData)serverData);
    }

    public void sort() {
        switch (this.sortOrder) {
            default: {
                Collections.shuffle(this.f_99673_.m_6702_());
                break;
            }
            case PLAYER: {
                Collections.sort(this.f_99673_.m_6702_(), PlayerComparator.INSTANCE);
                break;
            }
            case UPTIME: {
                Collections.sort(this.f_99673_.m_6702_(), UptimeComparator.INSTANCE);
                break;
            }
            case NAME: {
                Collections.sort(this.f_99673_.m_6702_(), ServerNameComparator.INSTANCE);
                break;
            }
            case LOCATION: {
                Collections.sort(this.f_99673_.m_6702_(), LocationComparator.INSTANCE);
                break;
            }
            case PING: {
                Collections.sort(this.f_99673_.m_6702_(), PingComparator.INSTANCE);
            }
        }
    }
}

