/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.multiplayer;

import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.client.screen.ScreenHooks;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.module.chat.screen.ChatScreen;
import net.creeperhost.minetogether.module.multiplayer.screen.JoinMultiplayerScreenPublic;
import net.creeperhost.minetogether.module.multiplayer.screen.ServerTypeScreen;
import net.creeperhost.minetogether.screen.SettingsScreen;
import net.creeperhost.polylib.client.screen.ButtonHelper;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonMultiple;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class MultiPlayerModule {
    public static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        if (screen instanceof JoinMultiplayerScreen) {
            JoinMultiplayerScreen multiplayerScreen = (JoinMultiplayerScreen)screen;
            MultiPlayerModule.updateMultiPlayerScreenButtons(multiplayerScreen);
            if (!(screen instanceof JoinMultiplayerScreenPublic)) {
                Button serverListButton = new Button(screen.f_96543_ - 105, 5, 100, 20, (Component)new TranslatableComponent("minetogether.multiplayer.serverlist"), p -> Minecraft.m_91087_().m_91152_((Screen)new ServerTypeScreen(screen)));
                ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)serverListButton);
                serverListButton.f_93623_ = !Config.getInstance().getFirstConnect();
                ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)new ButtonMultiple(screen.f_96543_ - 125, 5, 1, Constants.WIDGETS_LOCATION, p -> {
                    if (Config.getInstance().isChatEnabled()) {
                        Minecraft.m_91087_().m_91152_((Screen)new ChatScreen(screen));
                    } else {
                        Minecraft.m_91087_().m_91152_((Screen)new SettingsScreen(screen));
                    }
                }));
            }
        }
    }

    public static void updateMultiPlayerScreenButtons(JoinMultiplayerScreen multiplayerScreen) {
        try {
            Button cancel;
            Button direct;
            Button delete;
            Button edit;
            ++ButtonHelper.findButton((String)I18n.m_118938_((String)"selectServer.select", (Object[])new Object[0]), (Screen)multiplayerScreen).f_93620_;
            ButtonHelper.removeButton((String)I18n.m_118938_((String)"selectServer.refresh", (Object[])new Object[0]), (Screen)multiplayerScreen);
            Button addButton = ButtonHelper.findButton((String)I18n.m_118938_((String)"selectServer.add", (Object[])new Object[0]), (Screen)multiplayerScreen);
            if (addButton != null) {
                addButton.f_93620_ -= 104;
                addButton.m_93674_(addButton.m_5711_() + 27);
            }
            if ((edit = ButtonHelper.findButton((String)I18n.m_118938_((String)"selectServer.edit", (Object[])new Object[0]), (Screen)multiplayerScreen)) != null) {
                edit.m_93674_(edit.m_5711_() - 9);
                ++edit.f_93620_;
            }
            if ((delete = ButtonHelper.findButton((String)I18n.m_118938_((String)"selectServer.delete", (Object[])new Object[0]), (Screen)multiplayerScreen)) != null) {
                delete.f_93620_ -= 16;
                delete.m_93674_(delete.m_5711_() - 6);
            }
            if ((direct = ButtonHelper.findButton((String)I18n.m_118938_((String)"selectServer.direct", (Object[])new Object[0]), (Screen)multiplayerScreen)) != null) {
                direct.f_93620_ = multiplayerScreen.f_96543_ / 2 - 23;
                direct.f_93621_ = multiplayerScreen.f_96544_ - 28;
                direct.m_93674_(direct.m_5711_());
            }
            if ((cancel = ButtonHelper.findButton((String)I18n.m_118938_((String)"selectServer.cancel", (Object[])new Object[0]), (Screen)multiplayerScreen)) != null) {
                ++cancel.f_93620_;
                cancel.m_93674_(cancel.m_5711_() - 2);
            }
            if (!(multiplayerScreen instanceof JoinMultiplayerScreenPublic)) {
                ScreenHooks.addRenderableWidget((Screen)multiplayerScreen, (AbstractWidget)new Button(multiplayerScreen.f_96543_ / 2 + 80, multiplayerScreen.f_96544_ - 52, 74, 20, (Component)new TranslatableComponent("selectServer.refresh"), p -> Minecraft.m_91087_().m_91152_((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

