/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.connect;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.module.connect.ConnectHelper;
import net.creeperhost.minetogether.module.connect.FriendDetector;
import net.creeperhost.minetogether.module.connect.LanServerInfoConnect;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.server.LanServer;
import net.minecraft.client.server.LanServerDetection;

public class FriendsServerList
extends LanServerDetection.LanServerList {
    private final LanServerDetection.LanServerList wrapped;
    public static ScheduledExecutorService detectorExecutor;
    private boolean oursWasUpdated;
    private final List<LanServer> ourLanServers = new ArrayList<LanServer>();
    final JoinMultiplayerScreen owner;
    FriendDetector detector;
    private final List<FriendDetector.PendingFriend> pendingFriendServers = new ArrayList<FriendDetector.PendingFriend>();
    private long lastCheckTime = System.currentTimeMillis() - 1000L;

    public FriendsServerList(JoinMultiplayerScreen owner, LanServerDetection.LanServerList wrapped) {
        this.wrapped = wrapped;
        this.owner = owner;
        this.oursWasUpdated = true;
        if (ConnectHelper.isEnabled) {
            detectorExecutor = Executors.newSingleThreadScheduledExecutor();
            detectorExecutor.scheduleAtFixedRate(new FriendDetector(this), 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public synchronized void addOurServer(FriendDetector.PendingFriend friend) {
        LanServerInfoConnect lanServerInfo = new LanServerInfoConnect(friend);
        this.ourLanServers.add(lanServerInfo);
        this.oursWasUpdated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPendingServer(FriendDetector.PendingFriend data) {
        List<FriendDetector.PendingFriend> list = this.pendingFriendServers;
        synchronized (list) {
            for (FriendDetector.PendingFriend server : this.pendingFriendServers) {
                if (!data.getAddress().equals(server.getAddress())) continue;
                return;
            }
            List<LanServer> list2 = this.ourLanServers;
            synchronized (list2) {
                for (LanServer server : this.ourLanServers) {
                    if (!data.getAddress().equals(server.m_120079_())) continue;
                    return;
                }
            }
            this.pendingFriendServers.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean m_120095_() {
        long curTime = System.currentTimeMillis();
        if (this.lastCheckTime + 1000L <= curTime) {
            ArrayList<FriendDetector.PendingFriend> removingServers = new ArrayList<FriendDetector.PendingFriend>();
            List<FriendDetector.PendingFriend> list = this.pendingFriendServers;
            synchronized (list) {
                for (FriendDetector.PendingFriend friendServer : this.pendingFriendServers) {
                    removingServers.add(friendServer);
                    this.addOurServer(friendServer);
                    this.oursWasUpdated = true;
                }
                this.pendingFriendServers.removeAll(removingServers);
            }
            this.lastCheckTime = System.currentTimeMillis();
        }
        return this.oursWasUpdated || this.wrapped.m_120095_();
    }

    public synchronized void m_120096_(String pingResponse, InetAddress ipAddress) {
        this.wrapped.m_120096_(pingResponse, ipAddress);
    }

    public synchronized void m_120099_() {
        this.wrapped.m_120099_();
        this.oursWasUpdated = false;
    }

    public synchronized List<LanServer> m_120100_() {
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)Iterables.concat((Iterable)this.wrapped.m_120100_(), this.ourLanServers)));
    }

    public void removed() {
        if (detectorExecutor != null) {
            detectorExecutor.shutdown();
        }
    }
}

