/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.connect;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.client.screen.ScreenHooks;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.module.connect.ConnectHandler;
import net.creeperhost.minetogether.module.connect.ConnectHelper;
import net.creeperhost.minetogether.module.connect.GuiShareToFriends;
import net.creeperhost.polylib.client.screen.ButtonHelper;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;

public class ConnectModule {
    public static Executor connectExecutor = Executors.newSingleThreadExecutor();
    public static boolean isInitted = false;

    public static void init() {
        CompletableFuture.runAsync(ConnectHandler::connectToProc, connectExecutor);
        isInitted = true;
        Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("minetogether-connect-%d").build());
        ClientGuiEvent.INIT_POST.register(ConnectModule::onScreenOpen);
        LifecycleEvent.SERVER_STOPPING.register(ConnectModule::onServerStopping);
    }

    public static void onServerStopping(MinecraftServer server) {
        if (ConnectHelper.isShared(server)) {
            ConnectHandler.close();
        }
    }

    private static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        IntegratedServer integratedServer;
        if (screen instanceof PauseScreen && (integratedServer = Minecraft.m_91087_().m_91092_()) != null) {
            AbstractWidget feedBack = ButtonHelper.removeButton((String)"menu.sendFeedback", (Screen)screen);
            AbstractWidget bugs = ButtonHelper.removeButton((String)"menu.reportBugs", (Screen)screen);
            Button openToLan = ButtonHelper.findButton((String)"menu.shareToLan", (Screen)screen);
            Button options = ButtonHelper.findButton((String)"menu.options", (Screen)screen);
            if (openToLan != null && feedBack != null) {
                openToLan.f_93621_ = feedBack.f_93621_;
            }
            Button guiButton = new Button(screen.f_96543_ / 2 - 102, screen.f_96544_ / 4 + 72 + -16, 98, 20, (Component)new TranslatableComponent("minetogether.connect.open"), button -> Minecraft.m_91087_().m_91152_((Screen)new GuiShareToFriends(screen)));
            guiButton.f_93623_ = !integratedServer.m_6992_();
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)guiButton);
            if (bugs == null || feedBack == null) {
                return;
            }
            Button ourFeedback = new Button(bugs.f_93620_, options.f_93621_, feedBack.m_5711_(), 20, (Component)new TranslatableComponent("menu.reportBugs"), button -> {
                String s = Config.getInstance().getIssueTrackerUrl();
                Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(p_213069_2_ -> {
                    if (p_213069_2_) {
                        Util.m_137581_().m_137646_(s);
                    }
                    Minecraft.m_91087_().m_91152_(screen);
                }, s, true));
            });
            ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)ourFeedback);
        }
    }
}

