/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.connect;

import com.google.gson.Gson;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import net.creeperhost.minetogether.MineTogetherCommon;
import net.creeperhost.minetogether.module.connect.ConnectHelper;
import net.creeperhost.minetogetherconnect.ConnectMain;

public class ConnectHandler {
    private static final HashMap<Integer, ResponseInfo> awaiting = new HashMap();
    private static final Object lock = new Object();
    private static final Gson gson = new Gson();
    private static Socket socket = null;

    public static void connectToProc() {
        ConnectHelper.isEnabled = ConnectMain.doAuth();
        if (!ConnectHelper.isEnabled) {
            MineTogetherCommon.logger.info("MineTogether Connect not enabled: " + ConnectMain.authError);
        }
    }

    public static boolean sendMessage(Message message, Function<Response, Void> callback) {
        return true;
    }

    public static void openCallback(Consumer<String> messageRelayer, Consumer<Response> responseConsumer) {
        ConnectMain.listen((success, message) -> {
            Response response = new Response();
            response.success = success;
            response.message = message;
            responseConsumer.accept(response);
        }, messageRelayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Response> E blocking(Function<Function<E, Void>, Void> func) {
        AtomicReference tempResponse = new AtomicReference();
        Object tempLock = new Object();
        func.apply(response -> {
            tempResponse.set(response);
            Object object = tempLock;
            synchronized (object) {
                tempLock.notifyAll();
            }
            return null;
        });
        try {
            Object object = tempLock;
            synchronized (object) {
                tempLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (E)((Response)tempResponse.get());
    }

    public static void close() {
        ConnectMain.close();
    }

    public static FriendsResponse getFriendsBlocking() {
        return ConnectMain.getBackendServer().getFriends();
    }

    static class Response
    extends Message {
        private boolean success;
        private String message;

        Response() {
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class FriendsResponse
    extends Response {
        private ArrayList<Friend> friends;

        public ArrayList<Friend> getFriends() {
            return this.friends;
        }

        static class Friend {
            private String hash;
            private String displayName;
            private int port;

            Friend() {
            }

            public String getHash() {
                return this.hash;
            }

            public String getDisplayName() {
                return this.displayName;
            }

            public int getPort() {
                return this.port;
            }
        }
    }

    private static class ResponseInfo<T extends Response> {
        private final Class<T> clazz;
        private final Function<T, Void> callback;

        private ResponseInfo(Class<T> clazz, Function<T, Void> callback) {
            this.clazz = clazz;
            this.callback = callback;
        }

        public Class<T> getClazz() {
            return this.clazz;
        }

        public Function<T, Void> getCallback() {
            return this.callback;
        }
    }

    private static class Message {
        private static final AtomicInteger lastId = new AtomicInteger(0);
        private int id;
        private String type;

        private Message(String type) {
            this.id = lastId.getAndIncrement();
            this.type = type;
        }

        private Message() {
        }

        public int getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }
    }
}

