/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import net.creeperhost.minetogether.module.chat.screen.widgets.GuiButtonChat;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class GuiButtonPair
extends Button {
    GuiButtonChat button1;
    GuiButtonChat button2;
    GuiButtonChat button3;
    ArrayList<GuiButtonChat> buttons = new ArrayList();
    public int activeButton;
    private final boolean stack;
    private final boolean swapOnClick;
    private final boolean vertical;

    public GuiButtonPair(int x, int y, int widthIn, int heightIn, int state, boolean stack, boolean swapOnClick, boolean vertical, Button.OnPress onPress, String ... buttonTexts) {
        super(x, y, widthIn, heightIn, (Component)new TranslatableComponent(buttonTexts[0]), onPress);
        this.activeButton = state;
        this.swapOnClick = swapOnClick;
        this.stack = stack;
        this.vertical = vertical;
        for (String button : buttonTexts) {
            this.buttons.add(new GuiButtonChat(0, 0, 0, heightIn, button, onPress));
        }
        this.buttons.get(this.activeButton).setActive(true);
        this.button1 = this.buttons.get(0);
        this.button2 = this.buttons.get(1);
        this.setButtonDetails();
    }

    public ArrayList<GuiButtonChat> getButtons() {
        return this.buttons;
    }

    private void setButtonDetails() {
        int buttWidth = this.f_93618_ / this.buttons.size();
        int baseX = this.f_93620_;
        int baseY = this.f_93621_;
        int buttonCount = this.buttons.size();
        for (int buttonNum = 0; buttonNum < buttonCount; ++buttonNum) {
            GuiButtonChat button = this.buttons.get(buttonNum);
            int visibleNum = buttonNum;
            if (this.swapOnClick) {
                visibleNum = (buttonNum + buttonCount - this.activeButton) % buttonCount;
            }
            button.m_93674_(buttWidth);
            if (this.stack) {
                button.f_93620_ = baseX;
                button.f_93621_ = baseY + visibleNum * this.f_93619_;
                continue;
            }
            button.f_93620_ = baseX + visibleNum * buttWidth;
            button.f_93621_ = baseY;
        }
    }

    public void m_6305_(PoseStack matrixStack, int p_191745_2_, int p_191745_3_, float p_191745_4_) {
        double mouseX = p_191745_2_;
        double mouseY = p_191745_3_;
        float scale = 0.75f;
        float xTranslate = -this.buttons.get((int)0).f_93620_;
        float yTranslate = -this.buttons.get((int)0).f_93621_;
        int buttonCount = this.buttons.size();
        int[] cachedX = new int[buttonCount];
        int[] cachedY = new int[buttonCount];
        if (this.vertical) {
            float tempTranslateX;
            double xDiff = mouseX - (double)this.button1.f_93620_;
            double yDiff = mouseY - (double)this.button1.f_93621_;
            mouseX = yDiff / (double)scale;
            mouseY = xDiff / (double)scale + (double)this.f_93619_;
            int buttWidth = this.f_93618_ / this.buttons.size();
            for (int buttNum = 0; buttNum < buttonCount; ++buttNum) {
                GuiButtonChat button = this.buttons.get(buttNum);
                int visibleNum = buttNum;
                if (this.swapOnClick) {
                    visibleNum = (buttNum + buttonCount - this.activeButton) % buttonCount;
                }
                cachedX[buttNum] = button.f_93620_;
                cachedY[buttNum] = button.f_93621_;
                button.f_93620_ = buttWidth * visibleNum;
                button.f_93621_ = 0;
            }
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85836_();
            if (this.stack) {
                tempTranslateX = -xTranslate + (float)(this.f_93619_ * 2);
                tempTranslateY = -yTranslate - (float)this.f_93618_;
            } else {
                tempTranslateX = -xTranslate * (1.0f / scale);
                tempTranslateY = -yTranslate * (1.0f / scale);
            }
            matrixStack.m_85837_((double)tempTranslateX, (double)(tempTranslateY -= scale), 0.0);
            matrixStack.m_85845_(new Quaternion(-10.0f, 0.0f, 90.0f, true));
        }
        for (GuiButtonChat button : this.buttons) {
            button.m_6305_(matrixStack, (int)mouseX, (int)mouseY, p_191745_4_);
        }
        if (this.vertical) {
            matrixStack.m_85845_(new Quaternion(-10.0f, 0.0f, 90.0f, true));
            matrixStack.m_85849_();
            matrixStack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
            for (int buttNum = 0; buttNum < buttonCount; ++buttNum) {
                GuiButtonChat button;
                button = this.buttons.get(buttNum);
                button.f_93620_ = cachedX[buttNum];
                button.f_93621_ = cachedY[buttNum];
            }
        }
    }

    public boolean m_6375_(double mouseXIn, double mouseYIn, int p_mouseClicked_5_) {
        double mouseX = mouseXIn;
        double mouseY = mouseYIn;
        if (this.vertical) {
            double xDiff = (mouseX - (double)this.button1.f_93620_) / 0.75;
            double yDiff = (mouseY - (double)this.button1.f_93621_) / 0.75;
            mouseX = (double)this.button1.f_93620_ + yDiff;
            mouseY = (double)this.button1.f_93621_ + xDiff + (double)this.f_93619_;
        }
        boolean pressed = false;
        for (int buttonNum = 0; buttonNum < this.buttons.size(); ++buttonNum) {
            GuiButtonChat button = this.buttons.get(buttonNum);
            if (!button.m_6375_(mouseX, mouseY, p_mouseClicked_5_)) continue;
            if (this.activeButton != buttonNum) {
                this.buttons.get(this.activeButton).setActive(false);
            }
            this.activeButton = buttonNum;
            button.setActive(true);
            this.m_5691_();
            pressed = true;
            break;
        }
        return pressed;
    }
}

