/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen.social;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.List;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.io.sentry.Sentry;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.screen.social.MineTogetherSocialChatScreen;
import net.creeperhost.minetogether.module.chat.screen.social.MineTogetherSocialInteractionsScreen;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonString;
import net.creeperhost.polylib.client.toast.SimpleToast;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FastColor;

public class ProfileEntry
extends ContainerObjectSelectionList.Entry<ProfileEntry> {
    private final Profile profile;
    private final List<GuiEventListener> children;
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final Button removeButton;
    private final Button addToPartyButton;
    private final Button muteButton;
    private final Button openDMButton;
    private final MineTogetherSocialInteractionsScreen mineTogetherSocialinteractionsScreen;

    public ProfileEntry(Profile profile, MineTogetherSocialInteractionsScreen mineTogetherSocialinteractionsScreen) {
        this.profile = profile;
        this.mineTogetherSocialinteractionsScreen = mineTogetherSocialinteractionsScreen;
        this.removeButton = new ButtonString(0, 0, 10, 10, (Component)new TranslatableComponent(ChatFormatting.RED + new String(Character.toChars(10006))), button -> {
            switch (this.mineTogetherSocialinteractionsScreen.getPage()) {
                case BLOCKED: {
                    ChatModule.unmuteUser(profile.getLongHash());
                    this.refreshPage();
                    break;
                }
                case FRIENDS: {
                    try {
                        ChatCallbacks.removeFriend(profile.getFriendCode(), MineTogetherClient.getPlayerHash());
                    }
                    catch (IOException e) {
                        Sentry.captureException(e);
                    }
                    profile.setFriend(false);
                    KnownUsers.update(profile);
                    this.refreshPage();
                    break;
                }
                case PARTY: {
                    profile.setPartyMember(false);
                    KnownUsers.update(profile);
                    this.refreshPage();
                }
            }
        });
        this.addToPartyButton = new ButtonString(0, 0, 10, 10, (Component)new TranslatableComponent(ChatFormatting.GREEN + new String(Character.toChars(10010))), button -> {
            switch (this.mineTogetherSocialinteractionsScreen.getPage()) {
                case FRIENDS: {
                    String name;
                    String string = name = profile.isFriend() ? profile.getFriendName() : profile.getUserDisplay();
                    if (profile.isOnline()) {
                        SimpleToast simpleToast = new SimpleToast((Component)new TextComponent("Adding " + name + " to Party"), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_LOCATION);
                        Minecraft.m_91087_().m_91300_().m_94922_((Toast)simpleToast);
                        ChatHandler.sendPartyInvite(profile.getMediumHash(), MineTogetherChat.profile.get().getMediumHash());
                    } else {
                        SimpleToast simpleToast = new SimpleToast((Component)new TextComponent("Unable to send invite      " + name + " is offline"), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_LOCATION);
                        Minecraft.m_91087_().m_91300_().m_94922_((Toast)simpleToast);
                    }
                    this.refreshPage();
                }
            }
        });
        this.muteButton = new ImageButton(0, 0, 20, 20, 20, 38, 20, Constants.SOCIAL_INTERACTIONS_LOCATION, 256, 256, button -> {
            ChatModule.muteUser(profile.getLongHash());
            this.refreshPage();
        });
        this.openDMButton = new ImageButton(0, 0, 20, 20, 0, 38, 20, Constants.SOCIAL_INTERACTIONS_LOCATION, 256, 256, button -> {
            if (profile != null) {
                if (profile.isOnline()) {
                    Minecraft.m_91087_().m_91152_((Screen)new MineTogetherSocialChatScreen((Screen)mineTogetherSocialinteractionsScreen, profile));
                } else {
                    SimpleToast simpleToast = new SimpleToast((Component)new TextComponent("User is offline"), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_LOCATION);
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)simpleToast);
                }
            }
        });
        this.children = ImmutableList.of((Object)this.removeButton, (Object)this.addToPartyButton, (Object)this.muteButton, (Object)this.openDMButton);
    }

    public void refreshPage() {
        this.mineTogetherSocialinteractionsScreen.showPage(this.mineTogetherSocialinteractionsScreen.getPage());
    }

    public void m_6311_(PoseStack poseStack, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
        int t;
        int p = k + 4;
        int q = j + (m - 24) / 2;
        int r = p + 24 + 4;
        TranslatableComponent component = new TranslatableComponent(this.profile.getUserDisplay());
        if (component.equals(TextComponent.f_131282_)) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)k, (int)j, (int)(k + l), (int)(j + m), (int)FastColor.ARGB32.m_13660_((int)255, (int)74, (int)74, (int)74));
            t = j + (m - 9) / 2;
        } else {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)k, (int)j, (int)(k + l), (int)(j + m), (int)FastColor.ARGB32.m_13660_((int)255, (int)48, (int)48, (int)48));
            t = j + (m - 18) / 2;
            this.minecraft.f_91062_.m_92889_(poseStack, (Component)component, (float)p, (float)(t + 12), FastColor.ARGB32.m_13660_((int)140, (int)255, (int)255, (int)255));
        }
        this.minecraft.f_91062_.m_92883_(poseStack, this.profile.isFriend() ? this.profile.getFriendName() : this.profile.getUserDisplay(), (float)p, (float)t, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        if (this.mineTogetherSocialinteractionsScreen.getPage() == MineTogetherSocialInteractionsScreen.Page.FRIENDS) {
            this.addToPartyButton.f_93620_ = k + (l - this.addToPartyButton.m_5711_() - 4);
            this.addToPartyButton.f_93621_ = j + ((m - this.addToPartyButton.m_93694_()) / 2 + 10);
            this.addToPartyButton.m_6305_(poseStack, n, o, f);
            this.addToPartyButton.f_93623_ = true;
        } else {
            this.addToPartyButton.f_93620_ = 0;
            this.addToPartyButton.f_93621_ = 0;
        }
        if (this.removeButton != null && this.mineTogetherSocialinteractionsScreen.getPage() != MineTogetherSocialInteractionsScreen.Page.ALL) {
            this.removeButton.f_93620_ = k + (l - this.removeButton.m_5711_() - 4);
            this.removeButton.f_93621_ = j + ((m - this.removeButton.m_93694_()) / 2 - 10);
            this.removeButton.m_6305_(poseStack, n, o, f);
            this.openDMButton.f_93620_ = k + (l - this.openDMButton.m_5711_() - 4 - 15);
            this.openDMButton.f_93621_ = j + (m - this.openDMButton.m_93694_()) / 2;
            this.openDMButton.m_6305_(poseStack, n, o, f);
        } else {
            if (this.removeButton != null) {
                this.removeButton.f_93620_ = 0;
                this.removeButton.f_93621_ = 0;
            }
            if (this.openDMButton != null && this.muteButton != null) {
                this.muteButton.f_93620_ = k + (l - this.muteButton.m_5711_() - 4) - 20;
                this.muteButton.f_93621_ = j + (m - this.muteButton.m_93694_()) / 2;
                if (this.profile.isMuted()) {
                    this.muteButton.f_93623_ = false;
                }
                this.muteButton.m_6305_(poseStack, n, o, f);
                this.openDMButton.f_93620_ = k + (l - this.openDMButton.m_5711_() - 4);
                this.openDMButton.f_93621_ = j + (m - this.openDMButton.m_93694_()) / 2;
                this.openDMButton.m_6305_(poseStack, n, o, f);
            }
        }
    }

    public void renderTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.removeButton.m_198029_()) {
            TranslatableComponent component1 = new TranslatableComponent("");
            switch (this.mineTogetherSocialinteractionsScreen.getPage()) {
                case PARTY: {
                    component1 = new TranslatableComponent("Remove from party");
                    break;
                }
                case FRIENDS: {
                    component1 = new TranslatableComponent("Remove Friend");
                    break;
                }
                case BLOCKED: {
                    component1 = new TranslatableComponent("Unblock");
                }
            }
            this.mineTogetherSocialinteractionsScreen.m_96602_(poseStack, (Component)component1, mouseX, mouseY);
        }
        if (this.addToPartyButton.m_198029_()) {
            this.mineTogetherSocialinteractionsScreen.m_96602_(poseStack, (Component)new TranslatableComponent("Add to party"), mouseX, mouseY);
        }
        if (this.openDMButton.m_198029_()) {
            this.mineTogetherSocialinteractionsScreen.m_96602_(poseStack, (Component)new TranslatableComponent("Direct messages"), mouseX, mouseY);
        }
        if (this.muteButton.m_198029_()) {
            this.mineTogetherSocialinteractionsScreen.m_96602_(poseStack, (Component)new TranslatableComponent("Block"), mouseX, mouseY);
        }
    }

    public List<GuiEventListener> getChildren() {
        return this.children;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public List<? extends NarratableEntry> m_142437_() {
        return null;
    }
}

